/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.models.HttpConfigurationMethod;
import com.azure.resourcemanager.network.models.HttpHeader;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ConnectionMonitorHttpConfiguration {
    @JsonProperty(value="port")
    private Integer port;
    @JsonProperty(value="method")
    private HttpConfigurationMethod method;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="requestHeaders")
    private List<HttpHeader> requestHeaders;
    @JsonProperty(value="validStatusCodeRanges")
    private List<String> validStatusCodeRanges;
    @JsonProperty(value="preferHTTPS")
    private Boolean preferHttps;

    public Integer port() {
        return this.port;
    }

    public ConnectionMonitorHttpConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    public HttpConfigurationMethod method() {
        return this.method;
    }

    public ConnectionMonitorHttpConfiguration withMethod(HttpConfigurationMethod method) {
        this.method = method;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ConnectionMonitorHttpConfiguration withPath(String path) {
        this.path = path;
        return this;
    }

    public List<HttpHeader> requestHeaders() {
        return this.requestHeaders;
    }

    public ConnectionMonitorHttpConfiguration withRequestHeaders(List<HttpHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    public List<String> validStatusCodeRanges() {
        return this.validStatusCodeRanges;
    }

    public ConnectionMonitorHttpConfiguration withValidStatusCodeRanges(List<String> validStatusCodeRanges) {
        this.validStatusCodeRanges = validStatusCodeRanges;
        return this;
    }

    public Boolean preferHttps() {
        return this.preferHttps;
    }

    public ConnectionMonitorHttpConfiguration withPreferHttps(Boolean preferHttps) {
        this.preferHttps = preferHttps;
        return this;
    }

    public void validate() {
        if (this.requestHeaders() != null) {
            this.requestHeaders().forEach(e -> e.validate());
        }
    }
}

