/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ResourceNavigationLinkFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ResourceNavigationLink
extends SubResource {
    @JsonProperty(value="properties")
    private ResourceNavigationLinkFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private ResourceNavigationLinkFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ResourceNavigationLink withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ResourceNavigationLink withId(String id) {
        super.withId(id);
        return this;
    }

    public String linkedResourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedResourceType();
    }

    public ResourceNavigationLink withLinkedResourceType(String linkedResourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceNavigationLinkFormat();
        }
        this.innerProperties().withLinkedResourceType(linkedResourceType);
        return this;
    }

    public String link() {
        return this.innerProperties() == null ? null : this.innerProperties().link();
    }

    public ResourceNavigationLink withLink(String link) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceNavigationLinkFormat();
        }
        this.innerProperties().withLink(link);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

