/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.implementation.DnsManagementClientBuilder;
import com.azure.resourcemanager.dns.implementation.DnsZonesImpl;
import com.azure.resourcemanager.dns.models.DnsZones;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class DnsZoneManager
extends Manager<DnsManagementClient> {
    private DnsZones zones;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static DnsZoneManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return DnsZoneManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    public static DnsZoneManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new DnsZoneManager(httpPipeline, profile);
    }

    private DnsZoneManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new DnsManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public DnsZones zones() {
        if (this.zones == null) {
            this.zones = new DnsZonesImpl(this);
        }
        return this.zones;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public DnsZoneManager authenticate(TokenCredential credential, AzureProfile profile) {
            return DnsZoneManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public DnsZoneManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

