/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.ContainerType;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ContainerContext {
    private final String user;
    private final ContainerId containerId;
    private final Resource resource;
    private final ContainerType containerType;
    private final ExecutionType executionType;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ContainerContext(String user, ContainerId containerId, Resource resource) {
        this(user, containerId, resource, ContainerType.TASK);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ContainerContext(String user, ContainerId containerId, Resource resource, ContainerType containerType) {
        this(user, containerId, resource, containerType, ExecutionType.GUARANTEED);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public ContainerContext(String user, ContainerId containerId, Resource resource, ContainerType containerType, ExecutionType executionType) {
        this.user = user;
        this.containerId = containerId;
        this.resource = resource;
        this.containerType = containerType;
        this.executionType = executionType;
    }

    public String getUser() {
        return this.user;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }
}

