/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;

public class TaskStorageUtils {
    private TaskStorageUtils() {
    }

    public static Map<TaskLookup.TaskLookupType, TaskLookup> processTaskLookups(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, DateTime minCreationTimestamp) {
        LinkedHashMap<TaskLookup.TaskLookupType, TaskLookup> retVal = new LinkedHashMap<TaskLookup.TaskLookupType, TaskLookup>();
        for (Map.Entry<TaskLookup.TaskLookupType, TaskLookup> entry : taskLookups.entrySet()) {
            if (entry.getValue().isNil()) continue;
            if (entry.getKey() == TaskLookup.TaskLookupType.COMPLETE) {
                TaskLookup.CompleteTaskLookup completeTaskLookup = (TaskLookup.CompleteTaskLookup)entry.getValue();
                retVal.put(entry.getKey(), (TaskLookup)completeTaskLookup.withMinTimestampIfAbsent(minCreationTimestamp));
                continue;
            }
            retVal.put(entry.getKey(), entry.getValue());
        }
        return retVal;
    }
}

