/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.scheduledbatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.scheduledbatch.BatchSupervisorTaskReport;
import org.apache.druid.indexing.scheduledbatch.BatchSupervisorTaskStatus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.http.SqlTaskStatus;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class ScheduledBatchStatusTracker {
    private static final Duration MAX_STATUS_RETAIN_DURATION = Duration.standardDays((long)2L);
    private final ConcurrentHashMap<String, List<String>> supervisorToTaskIds = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SupervisorStatusSummary> supervisorToStatusSummary = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BatchSupervisorTaskStatus> recentTaskStatusMap = new ConcurrentHashMap();

    public void onTaskSubmitted(String supervisorId, SqlTaskStatus sqlTaskStatus) {
        String taskId = sqlTaskStatus.getTaskId();
        this.supervisorToTaskIds.computeIfAbsent(supervisorId, k -> new CopyOnWriteArrayList()).add(taskId);
        this.recentTaskStatusMap.put(taskId, new BatchSupervisorTaskStatus(supervisorId, TaskStatus.fromCode((String)sqlTaskStatus.getTaskId(), (TaskState)sqlTaskStatus.getState()), DateTimes.nowUtc()));
        this.supervisorToStatusSummary.computeIfAbsent(supervisorId, k -> new SupervisorStatusSummary()).incrementCount(TaskState.RUNNING);
    }

    public void onTaskCompleted(String taskId, TaskStatus taskStatus) {
        BatchSupervisorTaskStatus supervisorTaskStatus = this.recentTaskStatusMap.get(taskId);
        if (supervisorTaskStatus == null) {
            return;
        }
        String supervisorId = supervisorTaskStatus.getSupervisorId();
        this.recentTaskStatusMap.put(taskId, new BatchSupervisorTaskStatus(supervisorId, taskStatus, DateTimes.nowUtc()));
        this.supervisorToStatusSummary.computeIfAbsent(supervisorId, k -> new SupervisorStatusSummary()).incrementCount(taskStatus.getStatusCode());
    }

    public BatchSupervisorTaskReport getSupervisorTaskReport(String supervisorId) {
        List taskIds = this.supervisorToTaskIds.getOrDefault(supervisorId, Collections.emptyList());
        ArrayList<BatchSupervisorTaskStatus> recentTasks = new ArrayList<BatchSupervisorTaskStatus>();
        for (String taskId : taskIds) {
            BatchSupervisorTaskStatus taskStatus = this.recentTaskStatusMap.get(taskId);
            if (taskStatus == null) continue;
            recentTasks.add(taskStatus);
        }
        SupervisorStatusSummary summary = this.supervisorToStatusSummary.getOrDefault(supervisorId, new SupervisorStatusSummary());
        return new BatchSupervisorTaskReport(summary.getTotalSubmitted(), summary.getTotalSuccessful(), summary.getTotalFailed(), recentTasks);
    }

    public void cleanupStaleTaskStatuses(String supervisorId) {
        List<String> taskIds = this.supervisorToTaskIds.get(supervisorId);
        if (taskIds == null) {
            return;
        }
        HashSet staleTaskIds = new HashSet();
        DateTime expiryThreshold = DateTimes.nowUtc().minus((ReadableDuration)MAX_STATUS_RETAIN_DURATION);
        taskIds.forEach(taskId -> {
            BatchSupervisorTaskStatus status = this.recentTaskStatusMap.get(taskId);
            if (status != null && status.getUpdatedTime().isBefore((ReadableInstant)expiryThreshold)) {
                staleTaskIds.add(taskId);
            }
        });
        staleTaskIds.forEach(this.recentTaskStatusMap::remove);
    }

    private static class SupervisorStatusSummary {
        private final AtomicInteger totalSubmitted = new AtomicInteger(0);
        private final AtomicInteger totalSuccessful = new AtomicInteger(0);
        private final AtomicInteger totalFailed = new AtomicInteger(0);

        private SupervisorStatusSummary() {
        }

        void incrementCount(TaskState state) {
            if (state.isRunnable()) {
                this.totalSubmitted.incrementAndGet();
            } else if (state.isSuccess()) {
                this.totalSuccessful.incrementAndGet();
            } else {
                this.totalFailed.incrementAndGet();
            }
        }

        int getTotalSubmitted() {
            return this.totalSubmitted.get();
        }

        int getTotalSuccessful() {
            return this.totalSuccessful.get();
        }

        int getTotalFailed() {
            return this.totalFailed.get();
        }
    }
}

