/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.indexer.TaskIdStatus;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;

public interface MetadataStorageActionHandler {
    public void insert(@NotNull String var1, @NotNull DateTime var2, @NotNull String var3, @NotNull Task var4, boolean var5, @Nullable TaskStatus var6, @NotNull String var7, @NotNull String var8);

    public boolean setStatus(String var1, boolean var2, TaskStatus var3);

    public Optional<Task> getEntry(String var1);

    public Optional<TaskStatus> getStatus(String var1);

    @Nullable
    public TaskInfo getTaskInfo(String var1);

    public List<TaskInfo> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> var1, @Nullable String var2);

    public List<TaskIdStatus> getTaskStatusList(Map<TaskLookup.TaskLookupType, TaskLookup> var1, @Nullable String var2);

    default public List<TaskInfo> getTaskInfos(TaskLookup taskLookup, @Nullable String datasource) {
        return this.getTaskInfos(Collections.singletonMap(taskLookup.getType(), taskLookup), datasource);
    }

    public boolean addLock(String var1, TaskLock var2);

    public boolean replaceLock(String var1, long var2, TaskLock var4);

    public void removeLock(long var1);

    public void removeTasksOlderThan(long var1);

    public Map<Long, TaskLock> getLocks(String var1);

    @Nullable
    public Long getLockId(String var1, TaskLock var2);

    public void populateTaskTypeAndGroupIdAsync();
}

