/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.restrictions.common.PortRange;

public class PortRangeImpl
implements PortRange,
Comparable<PortRange> {
    private final int min;
    private final int max;

    public PortRangeImpl(int min, int max) {
        if (min > max) {
            throw new ParseInvalidRestrictionException("Minimum port %d cannot be greater than Maximum port %d", min, max);
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public int getMinimumPort() {
        return this.min;
    }

    @Override
    public int getMaximumPort() {
        return this.max;
    }

    @Override
    public boolean inRange(int port) {
        return port >= this.min && port <= this.max;
    }

    @Override
    public boolean contains(PortRange other) {
        if (this == other) {
            return true;
        }
        return this.getMinimumPort() <= other.getMinimumPort() && this.getMaximumPort() >= other.getMaximumPort();
    }

    public String toString() {
        if (this.min != this.max) {
            return String.format("%d-%d", this.min, this.max);
        }
        return Integer.toString(this.min);
    }

    @Override
    public int compareTo(PortRange other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        if (this.min < other.getMinimumPort()) {
            return -1;
        }
        if (this.min == other.getMinimumPort()) {
            if (this.max < other.getMaximumPort()) {
                return -1;
            }
            if (this.max == other.getMaximumPort()) {
                return 0;
            }
            return 1;
        }
        return 1;
    }
}

