/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.semantic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.common.semantic.SemanticCreator;
import org.apache.druid.error.DruidException;

public class SemanticUtils {
    private static final Map<Class<?>, Map<Class<?>, Function<?, ?>>> OVERRIDES = new LinkedHashMap();

    public static <C, T> void registerAsOverride(Class<C> clazz, Class<T> asInterface, Function<C, T> fn) {
        Map classOverrides = OVERRIDES.computeIfAbsent(clazz, theClazz -> new LinkedHashMap());
        Function oldVal = (Function)classOverrides.get(asInterface);
        if (oldVal != null) {
            throw DruidException.defensive("Attempt to side-override the same interface [%s] multiple times for the same class [%s].", asInterface, clazz);
        }
        classOverrides.put(asInterface, fn);
    }

    public static <T> Map<Class<?>, Function<T, ?>> makeAsMap(Class<T> clazz) {
        HashMap retVal = new HashMap();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(SemanticCreator.class)) continue;
            if (method.getParameterCount() != 0) {
                throw DruidException.defensive("Method [%s] annotated with SemanticCreator was not 0-argument.", method);
            }
            retVal.put(method.getReturnType(), arg -> {
                try {
                    return method.invoke(arg, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw DruidException.defensive().build(e, "Problem invoking method [%s]", method);
                }
            });
        }
        Map<Class<?>, Function<?, ?>> classOverrides = OVERRIDES.get(clazz);
        if (classOverrides != null) {
            for (Map.Entry<Class<?>, Function<?, ?>> overrideEntry : classOverrides.entrySet()) {
                retVal.put(overrideEntry.getKey(), overrideEntry.getValue());
            }
        }
        return retVal;
    }
}

