/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class StandardURLClassLoader
extends URLClassLoader {
    private final List<ClassLoader> extensionDependencyClassLoaders;

    public StandardURLClassLoader(URL[] urls, ClassLoader druidLoader, List<ClassLoader> extensionDependencyClassLoaders) {
        super(urls, druidLoader);
        this.extensionDependencyClassLoaders = (List)Preconditions.checkNotNull(extensionDependencyClassLoaders, (Object)"extensionDependencyClassLoaders");
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            clazz = this.loadClassFromExtensionDependencies(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL resource = super.getResource(name);
        if (resource != null) {
            return resource;
        }
        return this.getResourceFromExtensionsDependencies(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterators.addAll(urls, (Iterator)Iterators.forEnumeration(super.getResources(name)));
        this.addExtensionResources(name, urls);
        return Iterators.asEnumeration(urls.iterator());
    }

    protected URL getResourceFromExtensionsDependencies(String name) {
        ClassLoader classLoader;
        URL resourceFromExtension = null;
        Iterator<ClassLoader> iterator = this.extensionDependencyClassLoaders.iterator();
        while (iterator.hasNext() && (resourceFromExtension = (classLoader = iterator.next()).getResource(name)) == null) {
        }
        return resourceFromExtension;
    }

    protected Class<?> loadClassFromExtensionDependencies(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.extensionDependencyClassLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException();
    }

    protected void addExtensionResources(String name, List<URL> urls) throws IOException {
        for (ClassLoader classLoader : this.extensionDependencyClassLoaders) {
            Iterators.addAll(urls, (Iterator)Iterators.forEnumeration(classLoader.getResources(name)));
        }
    }

    public List<ClassLoader> getExtensionDependencyClassLoaders() {
        return this.extensionDependencyClassLoaders;
    }
}

