/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.IPAddressString;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.IPv6AddressExprUtils;

public class IPv6AddressMatchExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "ipv6_match";
    private static final int ARG_SUBNET = 1;

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        try {
            final Expr arg = args.get(0);
            final IPAddressString blockString = this.getSubnetInfo(args);
            class IPv6AddressMatchExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                private IPv6AddressMatchExpr(List<Expr> args) {
                    super(this$0, args);
                }

                @Override
                @Nonnull
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    boolean match;
                    ExprEval eval = arg.eval(bindings);
                    switch ((ExprType)eval.type().getType()) {
                        case STRING: {
                            match = this.isStringMatch(eval.asString());
                            break;
                        }
                        default: {
                            match = false;
                        }
                    }
                    return ExprEval.ofLongBoolean(match);
                }

                private boolean isStringMatch(String stringValue) {
                    IPAddressString addressString = IPv6AddressExprUtils.parseString(stringValue);
                    return addressString != null && blockString.prefixContains(addressString);
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.LONG;
                }
            }
            return new IPv6AddressMatchExpr(args);
        }
        catch (Exception e) {
            throw this.processingFailed(e, "failed to parse address", new Object[0]);
        }
    }

    private IPAddressString getSubnetInfo(List<Expr> args) {
        String subnetArgName = "subnet";
        Expr arg = args.get(1);
        this.validationHelperCheckArgIsLiteral(arg, subnetArgName);
        String subnet = (String)arg.getLiteralValue();
        if (!IPv6AddressExprUtils.isValidIPv6Subnet(subnet)) {
            throw this.validationFailed(subnetArgName + " arg has an invalid format: " + subnet, new Object[0]);
        }
        return new IPAddressString(subnet);
    }
}

