/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.IndexSpec;

public class DefaultColumnFormatConfig {
    private static final Logger LOG = new Logger(DefaultColumnFormatConfig.class);
    @JsonProperty(value="stringMultiValueHandlingMode")
    @Nullable
    private final Integer nestedColumnFormatVersion;
    @JsonProperty(value="nestedColumnFormatVersion")
    @Nullable
    private final String stringMultiValueHandlingMode;
    @JsonProperty(value="indexSpec")
    @Nullable
    private final IndexSpec indexSpec;

    @Nullable
    public static Integer validateNestedFormatVersion(@Nullable Integer formatVersion) {
        if (formatVersion != null && formatVersion != 5) {
            LOG.warn("Unsupported nested column format version[%s], using default version instead", formatVersion);
            return null;
        }
        return formatVersion;
    }

    @Nullable
    private static String validateMultiValueHandlingMode(@Nullable String stringMultiValueHandlingMode) {
        if (stringMultiValueHandlingMode != null) {
            try {
                DimensionSchema.MultiValueHandling.fromString(stringMultiValueHandlingMode);
            }
            catch (IllegalArgumentException e) {
                throw DruidException.forPersona(DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build("Invalid value[%s] specified for 'druid.indexing.formats.stringMultiValueHandlingMode'. Supported values are [%s].", stringMultiValueHandlingMode, Arrays.toString((Object[])DimensionSchema.MultiValueHandling.values()));
            }
        }
        return stringMultiValueHandlingMode;
    }

    @JsonCreator
    public DefaultColumnFormatConfig(@JsonProperty(value="stringMultiValueHandlingMode") @Nullable String stringMultiValueHandlingMode, @JsonProperty(value="nestedColumnFormatVersion") @Nullable Integer nestedColumnFormatVersion, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec) {
        DefaultColumnFormatConfig.validateMultiValueHandlingMode(stringMultiValueHandlingMode);
        DefaultColumnFormatConfig.validateNestedFormatVersion(nestedColumnFormatVersion);
        this.stringMultiValueHandlingMode = DefaultColumnFormatConfig.validateMultiValueHandlingMode(stringMultiValueHandlingMode);
        this.nestedColumnFormatVersion = nestedColumnFormatVersion;
        this.indexSpec = indexSpec;
    }

    @Nullable
    @JsonProperty(value="stringMultiValueHandlingMode")
    public String getStringMultiValueHandlingMode() {
        return this.stringMultiValueHandlingMode;
    }

    @Nullable
    @JsonProperty(value="nestedColumnFormatVersion")
    public Integer getNestedColumnFormatVersion() {
        return this.nestedColumnFormatVersion;
    }

    @Nullable
    @JsonProperty(value="indexSpec")
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultColumnFormatConfig that = (DefaultColumnFormatConfig)o;
        return Objects.equals(this.nestedColumnFormatVersion, that.nestedColumnFormatVersion) && Objects.equals(this.stringMultiValueHandlingMode, that.stringMultiValueHandlingMode) && Objects.equals(this.indexSpec, that.indexSpec);
    }

    public int hashCode() {
        return Objects.hash(this.nestedColumnFormatVersion, this.stringMultiValueHandlingMode, this.indexSpec);
    }

    public String toString() {
        return "DefaultColumnFormatConfig{stringMultiValueHandlingMode=" + this.stringMultiValueHandlingMode + ", nestedColumnFormatVersion=" + this.nestedColumnFormatVersion + ", indexSpec=" + this.indexSpec + "}";
    }
}

