/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;

public class VByte {
    public static int readInt(ByteBuffer buffer) {
        byte b = buffer.get();
        int v = b & 0x7F;
        if (b < 0) {
            return v;
        }
        b = buffer.get();
        v = (b & 0x7F) << 7 | v;
        if (b < 0) {
            return v;
        }
        b = buffer.get();
        v = (b & 0x7F) << 14 | v;
        if (b < 0) {
            return v;
        }
        b = buffer.get();
        v = (b & 0x7F) << 21 | v;
        if (b < 0) {
            return v;
        }
        v = (buffer.get() & 0x7F) << 28 | v;
        return v;
    }

    public static int writeInt(ByteBuffer buffer, int val) {
        int pos = buffer.position();
        if (val < 128) {
            buffer.put((byte)(val | 0x80));
        } else if (val < 16384) {
            buffer.put(VByte.extract7bits(0, val));
            buffer.put((byte)(VByte.extract7bitsmaskless(1, val) | 0x80));
        } else if (val < 0x200000) {
            buffer.put(VByte.extract7bits(0, val));
            buffer.put(VByte.extract7bits(1, val));
            buffer.put((byte)(VByte.extract7bitsmaskless(2, val) | 0x80));
        } else if (val < 0x10000000) {
            buffer.put(VByte.extract7bits(0, val));
            buffer.put(VByte.extract7bits(1, val));
            buffer.put(VByte.extract7bits(2, val));
            buffer.put((byte)(VByte.extract7bitsmaskless(3, val) | 0x80));
        } else {
            buffer.put(VByte.extract7bits(0, val));
            buffer.put(VByte.extract7bits(1, val));
            buffer.put(VByte.extract7bits(2, val));
            buffer.put(VByte.extract7bits(3, val));
            buffer.put((byte)(VByte.extract7bitsmaskless(4, val) | 0x80));
        }
        return buffer.position() - pos;
    }

    public static int computeIntSize(int val) {
        if (val < 128) {
            return 1;
        }
        if (val < 16384) {
            return 2;
        }
        if (val < 0x200000) {
            return 3;
        }
        if (val < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private static byte extract7bits(int i, int val) {
        return (byte)(val >> 7 * i & 0x7F);
    }

    private static byte extract7bitsmaskless(int i, int val) {
        return (byte)(val >> 7 * i);
    }
}

