/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.shim;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;
import org.apache.druid.segment.shim.ShimCursor;
import org.apache.druid.segment.shim.ShimMultiValueDimensionSelector;
import org.apache.druid.segment.shim.ShimNumericColumnValueSelector;
import org.apache.druid.segment.shim.ShimObjectColumnValueSelector;
import org.apache.druid.segment.shim.ShimSingleValueDimensionSelector;
import org.apache.druid.segment.shim.ShimVectorObjectDimSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class ShimColumnSelectorFactory
implements ColumnSelectorFactory {
    private final ShimCursor cursor;
    private final Map<DimensionSpec, DimensionSelector> dimensionSelectors = new HashMap<DimensionSpec, DimensionSelector>();
    private final Map<String, ColumnValueSelector<Object>> columnValueSelectors = new HashMap<String, ColumnValueSelector<Object>>();

    public ShimColumnSelectorFactory(ShimCursor cursor) {
        this.cursor = cursor;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return this.dimensionSelectors.computeIfAbsent(dimensionSpec, spec -> {
            if (spec.mustDecorate() || spec.getExtractionFn() != null) {
                throw DruidException.defensive("Only non-decorated dimensions can be vectorized.", new Object[0]);
            }
            String columnName = dimensionSpec.getDimension();
            ColumnCapabilities capabilities = this.cursor.vectorColumnSelectorFactory.getColumnCapabilities(columnName);
            if (capabilities == null) {
                return DimensionSelector.nilSelector();
            }
            if (capabilities.is(ValueType.STRING)) {
                if (ColumnProcessors.useDictionaryEncodedSelector(capabilities)) {
                    if (capabilities.hasMultipleValues().isMaybeTrue()) {
                        MultiValueDimensionVectorSelector vectorSelector = this.cursor.vectorColumnSelectorFactory.makeMultiValueDimensionSelector((DimensionSpec)spec);
                        return new ShimMultiValueDimensionSelector(this.cursor, vectorSelector);
                    }
                    SingleValueDimensionVectorSelector vectorSelector = this.cursor.vectorColumnSelectorFactory.makeSingleValueDimensionSelector((DimensionSpec)spec);
                    return new ShimSingleValueDimensionSelector(this.cursor, vectorSelector);
                }
                VectorObjectSelector vectorObjectSelector = this.cursor.vectorColumnSelectorFactory.makeObjectSelector(spec.getDimension());
                return new ShimVectorObjectDimSelector(this.cursor, vectorObjectSelector, capabilities.hasMultipleValues().isMaybeTrue());
            }
            if (capabilities.isNumeric()) {
                return ValueTypes.makeNumericWrappingDimensionSelector((ValueType)capabilities.getType(), this.makeColumnValueSelector(columnName), null);
            }
            return DimensionSelector.nilSelector();
        });
    }

    @Override
    public ColumnValueSelector makeColumnValueSelector(String columnName) {
        return this.columnValueSelectors.computeIfAbsent(columnName, column -> {
            ColumnCapabilities capabilities = this.cursor.vectorColumnSelectorFactory.getColumnCapabilities((String)column);
            if (capabilities == null) {
                return NilColumnValueSelector.instance();
            }
            if (capabilities.is(ValueType.STRING)) {
                return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName));
            }
            if (capabilities.isNumeric()) {
                return new ShimNumericColumnValueSelector(this.cursor, this.cursor.vectorColumnSelectorFactory.makeValueSelector(columnName), (ValueType)capabilities.getType());
            }
            return new ShimObjectColumnValueSelector(this.cursor, this.cursor.vectorColumnSelectorFactory.makeObjectSelector(columnName));
        });
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.cursor.vectorColumnSelectorFactory.getColumnCapabilities(column);
    }
}

