/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.RestoreWindow;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RestoreWindowStaxUnmarshaller
implements Unmarshaller<RestoreWindow, StaxUnmarshallerContext> {
    private static RestoreWindowStaxUnmarshaller instance;

    public RestoreWindow unmarshall(StaxUnmarshallerContext context) throws Exception {
        RestoreWindow restoreWindow = new RestoreWindow();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return restoreWindow;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("EarliestTime", targetDepth)) {
                    restoreWindow.setEarliestTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LatestTime", targetDepth)) continue;
                restoreWindow.setLatestTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return restoreWindow;
    }

    public static RestoreWindowStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RestoreWindowStaxUnmarshaller();
        }
        return instance;
    }
}

