/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.bloom;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.filter.BloomKFilter;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;

public abstract class BaseBloomFilterAggregator<TSelector>
implements BufferAggregator,
Aggregator {
    @Nullable
    private final ByteBuffer collector;
    protected final int maxNumEntries;
    protected final TSelector selector;

    BaseBloomFilterAggregator(TSelector selector, int maxNumEntries, boolean onHeap) {
        this.selector = selector;
        this.maxNumEntries = maxNumEntries;
        if (onHeap) {
            BloomKFilter bloomFilter = new BloomKFilter(maxNumEntries);
            this.collector = ByteBuffer.allocate(BloomKFilter.computeSizeBytes(maxNumEntries));
            BloomKFilter.serialize(this.collector, bloomFilter);
        } else {
            this.collector = null;
        }
    }

    abstract void bufferAdd(ByteBuffer var1);

    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        BloomKFilter filter = new BloomKFilter(this.maxNumEntries);
        BloomKFilter.serialize(mutationBuffer, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            this.bufferAdd(buf);
        }
        finally {
            buf.position(oldPosition);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        int sizeBytes = BloomKFilter.computeSizeBytes(this.maxNumEntries);
        mutationBuffer.limit(position + sizeBytes);
        ByteBuffer resultCopy = ByteBuffer.allocate(sizeBytes);
        resultCopy.put(mutationBuffer.slice());
        resultCopy.rewind();
        return resultCopy;
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getLong()");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getDouble()");
    }

    public void aggregate() {
        this.aggregate(this.collector, 0);
    }

    @Nullable
    public Object get() {
        return this.collector;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getFloat()");
    }

    public long getLong() {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getLong()");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("BloomFilterAggregator does not support getDouble()");
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

