/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.WritableMemory;

public class HllSketchMergeBufferAggregatorHelper {
    private final int lgK;
    private final TgtHllType tgtHllType;
    private final int size;
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<Union>> unions = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final byte[] emptyUnion;

    public HllSketchMergeBufferAggregatorHelper(int lgK, TgtHllType tgtHllType, int size) {
        this.lgK = lgK;
        this.tgtHllType = tgtHllType;
        this.size = size;
        this.emptyUnion = new byte[size];
        new Union(lgK, WritableMemory.writableWrap((byte[])this.emptyUnion));
    }

    public void init(ByteBuffer buf, int position) {
        this.createNewUnion(buf, position, false);
    }

    public HllSketch get(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN).writableRegion((long)position, (long)this.size);
        Union union = Union.writableWrap((WritableMemory)mem);
        return union.getResult(this.tgtHllType);
    }

    public int getLgK() {
        return this.lgK;
    }

    public int getSize() {
        return this.size;
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.createNewUnion(newBuffer, newPosition, true);
        Int2ObjectMap<Union> unionMap = this.unions.get(oldBuffer);
        if (unionMap != null) {
            unionMap.remove(oldPosition);
            if (unionMap.isEmpty()) {
                this.unions.remove(oldBuffer);
                this.memCache.remove(oldBuffer);
            }
        }
    }

    public Union getOrCreateUnion(ByteBuffer buf, int position) {
        Union union;
        Int2ObjectMap<Union> unionMap = this.unions.get(buf);
        Union union2 = union = unionMap != null ? (Union)unionMap.get(position) : null;
        if (union != null) {
            return union;
        }
        return this.createNewUnion(buf, position, true);
    }

    private Union createNewUnion(ByteBuffer buf, int position, boolean isWrapped) {
        if (!isWrapped) {
            this.initializeEmptyUnion(buf, position);
        }
        WritableMemory mem = this.getMemory(buf).writableRegion((long)position, (long)this.size);
        Union union = Union.writableWrap((WritableMemory)mem);
        Int2ObjectOpenHashMap unionMap = this.unions.get(buf);
        if (unionMap == null) {
            unionMap = new Int2ObjectOpenHashMap();
            this.unions.put(buf, (Int2ObjectMap<Union>)unionMap);
        }
        unionMap.put(position, (Object)union);
        return union;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeEmptyUnion(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            buf.put(this.emptyUnion);
        }
        finally {
            buf.position(oldPosition);
        }
    }

    public void clear() {
        this.unions.clear();
        this.memCache.clear();
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        WritableMemory mem = this.memCache.get(buffer);
        if (mem == null) {
            mem = WritableMemory.writableWrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            this.memCache.put(buffer, mem);
        }
        return mem;
    }
}

