/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class KllDoublesSketchToCDFPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final double[] splitPoints;

    @JsonCreator
    public KllDoublesSketchToCDFPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="splitPoints") double[] splitPoints) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.splitPoints = (double[])Preconditions.checkNotNull((Object)splitPoints, (Object)"array of split points is null");
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        KllDoublesSketch sketch = (KllDoublesSketch)this.field.compute(combinedAggregators);
        if (sketch.isEmpty()) {
            double[] cdf = new double[this.splitPoints.length + 1];
            Arrays.fill(cdf, Double.NaN);
            return cdf;
        }
        return sketch.getCDF(this.splitPoints);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE_ARRAY;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public double[] getSplitPoints() {
        return this.splitPoints;
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing histograms is not supported", new Object[0]);
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', field=" + this.field + ", splitPoints=" + Arrays.toString(this.splitPoints) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KllDoublesSketchToCDFPostAggregator that = (KllDoublesSketchToCDFPostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.splitPoints, that.splitPoints)) {
            return false;
        }
        return this.field.equals(that.field);
    }

    public int hashCode() {
        int hashCode = this.name.hashCode() * 31 + this.field.hashCode();
        hashCode = hashCode * 31 + Arrays.hashCode(this.splitPoints);
        return hashCode;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(34).appendCacheable((Cacheable)this.field);
        for (double value : this.splitPoints) {
            builder.appendDouble(value);
        }
        return builder.build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }
}

