/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.sql;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.msq.dart.controller.sql.DartSqlClient;
import org.apache.druid.msq.dart.controller.sql.DartSqlClientFactory;
import org.apache.druid.server.DruidNode;

@ManageLifecycle
public class DartSqlClients
implements DruidNodeDiscovery.Listener {
    @GuardedBy(value="clients")
    private final Map<DruidNode, DartSqlClient> clients = new HashMap<DruidNode, DartSqlClient>();
    private final DruidNode selfNode;
    private final DruidNodeDiscoveryProvider discoveryProvider;
    private final DartSqlClientFactory clientFactory;
    private volatile DruidNodeDiscovery discovery;

    @Inject
    public DartSqlClients(@Self DruidNode selfNode, DruidNodeDiscoveryProvider discoveryProvider, DartSqlClientFactory clientFactory) {
        this.selfNode = selfNode;
        this.discoveryProvider = discoveryProvider;
        this.clientFactory = clientFactory;
    }

    @LifecycleStart
    public void start() {
        this.discovery = this.discoveryProvider.getForNodeRole(NodeRole.BROKER);
        this.discovery.registerListener((DruidNodeDiscovery.Listener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DartSqlClient> getAllClients() {
        Map<DruidNode, DartSqlClient> map = this.clients;
        synchronized (map) {
            return ImmutableList.copyOf(this.clients.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
        Map<DruidNode, DartSqlClient> map = this.clients;
        synchronized (map) {
            for (DiscoveryDruidNode node : nodes) {
                DruidNode druidNode = node.getDruidNode();
                if (this.selfNode.equals((Object)druidNode)) continue;
                this.clients.computeIfAbsent(druidNode, this.clientFactory::makeClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
        Map<DruidNode, DartSqlClient> map = this.clients;
        synchronized (map) {
            for (DiscoveryDruidNode node : nodes) {
                this.clients.remove(node.getDruidNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        if (this.discovery != null) {
            this.discovery.removeListener((DruidNodeDiscovery.Listener)this);
            this.discovery = null;
        }
        Map<DruidNode, DartSqlClient> map = this.clients;
        synchronized (map) {
            this.clients.clear();
        }
    }
}

