/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.querykit.InputNumberDataSource;
import org.apache.druid.msq.querykit.RestrictedInputNumberDataSource;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.Query;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.policy.Policy;

public class DataServerQueryHandlerUtils {
    private DataServerQueryHandlerUtils() {
    }

    public static <R, T extends Query<R>> Query<R> prepareQuery(T query, int inputNumber, String dataSourceName) {
        return query.withDataSource(DataServerQueryHandlerUtils.transformDatasource(query.getDataSource(), inputNumber, dataSourceName));
    }

    static DataSource transformDatasource(DataSource dataSource, int inputNumber, String dataSourceName) {
        if (dataSource instanceof InputNumberDataSource) {
            InputNumberDataSource numberDataSource = (InputNumberDataSource)dataSource;
            if (numberDataSource.getInputNumber() == inputNumber) {
                return new TableDataSource(dataSourceName);
            }
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Cannot handle stage with multiple sources while querying realtime data. If using broadcast joins, try setting[%s] to[%s] in your query context.", new Object[]{"sqlJoinAlgorithm", JoinAlgorithm.SORT_MERGE.toString()});
        }
        if (dataSource instanceof RestrictedInputNumberDataSource) {
            RestrictedInputNumberDataSource restrictedDatasource = (RestrictedInputNumberDataSource)dataSource;
            if (restrictedDatasource.getInputNumber() == inputNumber) {
                return RestrictedDataSource.create((DataSource)new TableDataSource(dataSourceName), (Policy)restrictedDatasource.getPolicy());
            }
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Cannot handle stage with multiple sources while querying realtime data. If using broadcast joins, try setting[%s] to[%s] in your query context.", new Object[]{"sqlJoinAlgorithm", JoinAlgorithm.SORT_MERGE.toString()});
        }
        List transformed = dataSource.getChildren().stream().map(ds -> DataServerQueryHandlerUtils.transformDatasource(ds, inputNumber, dataSourceName)).collect(Collectors.toList());
        return dataSource.withChildren(transformed);
    }

    public static <RowType, QueryType> Yielder<RowType> createYielder(Sequence<QueryType> sequence, Function<Sequence<QueryType>, Sequence<RowType>> mappingFunction, ChannelCounters channelCounters) {
        return Yielders.each((Sequence)mappingFunction.apply(sequence).map(row -> {
            channelCounters.incrementRowCount();
            return row;
        }));
    }

    public static List<SegmentDescriptor> getMissingSegments(ResponseContext responseContext) {
        List missingSegments = responseContext.getMissingSegments();
        if (missingSegments == null) {
            return Collections.emptyList();
        }
        return missingSegments;
    }
}

