/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;

public class MSQPartitionAssignment {
    private final ClusterByPartitions partitions;
    private final Map<Integer, SegmentIdWithShardSpec> allocations;

    @JsonCreator
    public MSQPartitionAssignment(@JsonProperty(value="partitions") ClusterByPartitions partitions, @JsonProperty(value="allocations") Map<Integer, SegmentIdWithShardSpec> allocations) {
        this.partitions = (ClusterByPartitions)Preconditions.checkNotNull((Object)partitions, (Object)"partitions");
        this.allocations = (Map)Preconditions.checkNotNull(allocations, (Object)"allocations");
        for (int partitionNumber : allocations.keySet()) {
            if (partitionNumber >= 0 && partitionNumber < partitions.size()) continue;
            throw new IAE("Partition [%s] out of bounds", new Object[]{partitionNumber});
        }
    }

    @JsonProperty
    public ClusterByPartitions getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public Map<Integer, SegmentIdWithShardSpec> getAllocations() {
        return this.allocations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQPartitionAssignment that = (MSQPartitionAssignment)o;
        return Objects.equals(this.partitions, that.partitions) && Objects.equals(this.allocations, that.allocations);
    }

    public int hashCode() {
        return Objects.hash(this.partitions, this.allocations);
    }

    public String toString() {
        return "MSQPartitionAssignment{partitions=" + this.partitions + ", allocations=" + this.allocations + "}";
    }
}

