/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.util.concurrent.LinkedBlockingQueue;
import lombok.Generated;
import org.apache.fineract.cob.exceptions.LoanReadException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.item.ItemReader;
import org.springframework.lang.NonNull;

public abstract class AbstractLoanItemReader
implements ItemReader<Loan> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLoanItemReader.class);
    protected final LoanRepository loanRepository;
    private LinkedBlockingQueue<Long> remainingData;

    public Loan read() throws Exception {
        Long loanId = (Long)this.remainingData.poll();
        if (loanId != null) {
            try {
                return (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
            }
            catch (Exception e) {
                throw new LoanReadException(loanId, (Throwable)e);
            }
        }
        return null;
    }

    @AfterStep
    public ExitStatus afterStep(@NonNull StepExecution stepExecution) {
        return ExitStatus.COMPLETED;
    }

    @Generated
    public AbstractLoanItemReader(LoanRepository loanRepository) {
        this.loanRepository = loanRepository;
    }

    @Generated
    protected void setRemainingData(LinkedBlockingQueue<Long> remainingData) {
        this.remainingData = remainingData;
    }
}

