/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.core.diagnostics.performance.MeasuringUtil;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanDelinquencyRangeChangeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.delinquency.helper.DelinquencyEffectivePauseHelper;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.delinquency.validator.LoanDelinquencyActionData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SetLoanDelinquencyTagsBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SetLoanDelinquencyTagsBusinessStep.class);
    private final LoanAccountDomainService loanAccountDomainService;
    private final DelinquencyEffectivePauseHelper delinquencyEffectivePauseHelper;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final BusinessEventNotifierService businessEventNotifierService;

    public Loan execute(Loan loan) {
        if (loan == null) {
            log.debug("Ignoring delinquency tag processing for null loan.");
            return null;
        }
        String externalId = Optional.ofNullable(loan.getExternalId()).map(ExternalId::getValue).orElse(null);
        MeasuringUtil.measure((Runnable)new /* Unavailable Anonymous Inner Class!! */, duration -> log.debug("Ending delinquency tag processing for loan with Id [{}], account number [{}], external Id [{}], finished in [{}]ms", new Object[]{loan.getId(), loan.getAccountNumber(), externalId, duration.toMillis()}));
        return loan;
    }

    private boolean isDelinquencyOnPause(Loan loan, List<LoanDelinquencyActionData> effectiveDelinquencyList) {
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        boolean isPaused = SetLoanDelinquencyTagsBusinessStep.isPausedOnDate((LocalDate)businessDate, effectiveDelinquencyList);
        boolean wasPausedOneDayBefore = SetLoanDelinquencyTagsBusinessStep.isPausedOnDate((LocalDate)businessDate.minusDays(1L), effectiveDelinquencyList);
        if (isPaused && !wasPausedOneDayBefore || !isPaused && wasPausedOneDayBefore) {
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanDelinquencyRangeChangeBusinessEvent(loan));
        }
        return isPaused;
    }

    private static boolean isPausedOnDate(LocalDate date, List<LoanDelinquencyActionData> effectiveDelinquencyList) {
        return effectiveDelinquencyList.stream().anyMatch(pausePeriod -> !pausePeriod.getStartDate().isAfter(date) && !pausePeriod.getEndDate().isBefore(date));
    }

    public String getEnumStyledName() {
        return "LOAN_DELINQUENCY_CLASSIFICATION";
    }

    public String getHumanReadableName() {
        return "Loan Delinquency Classification";
    }

    @Generated
    public SetLoanDelinquencyTagsBusinessStep(LoanAccountDomainService loanAccountDomainService, DelinquencyEffectivePauseHelper delinquencyEffectivePauseHelper, DelinquencyReadPlatformService delinquencyReadPlatformService, BusinessEventNotifierService businessEventNotifierService) {
        this.loanAccountDomainService = loanAccountDomainService;
        this.delinquencyEffectivePauseHelper = delinquencyEffectivePauseHelper;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

