/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.executeemail;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailMessageWithAttachmentData;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaign;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessage;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageRepository;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageStatusType;
import org.apache.fineract.infrastructure.campaigns.email.domain.ScheduledEmailAttachmentFileFormat;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailMessageJobEmailService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.reportmailingjob.helper.IPv4Helper;
import org.apache.fineract.infrastructure.reportmailingjob.validation.ReportMailingJobValidator;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecuteEmailTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteEmailTasklet.class);
    private final EmailMessageRepository emailMessageRepository;
    private final EmailCampaignRepository emailCampaignRepository;
    private final LoanRepository loanRepository;
    private final SavingsAccountRepository savingsAccountRepository;
    private final EmailMessageJobEmailService emailMessageJobEmailService;
    private final ReadReportingService readReportingService;
    private final ReportMailingJobValidator reportMailingJobValidator;
    private final FineractProperties fineractProperties;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        if (IPv4Helper.applicationIsNotRunningOnLocalMachine()) {
            List emailMessages = this.emailMessageRepository.findByStatusType(EmailMessageStatusType.PENDING.getValue());
            for (EmailMessage emailMessage : emailMessages) {
                if (!ExecuteEmailTasklet.isValidEmail((String)emailMessage.getEmailAddress())) continue;
                EmailCampaign emailCampaign = this.emailCampaignRepository.findById((Object)((Long)emailMessage.getEmailCampaign().getId())).orElse(null);
                ScheduledEmailAttachmentFileFormat emailAttachmentFileFormat = null;
                if (emailCampaign.getEmailAttachmentFileFormat() != null) {
                    emailAttachmentFileFormat = ScheduledEmailAttachmentFileFormat.instance((String)emailCampaign.getEmailAttachmentFileFormat());
                }
                ArrayList<File> attachmentList = new ArrayList<File>();
                StringBuilder errorLog = new StringBuilder();
                if (emailAttachmentFileFormat != null && Arrays.asList(ScheduledEmailAttachmentFileFormat.validValues()).contains(emailAttachmentFileFormat.getId())) {
                    Report stretchyReport = emailCampaign.getStretchyReport();
                    String reportName = stretchyReport != null ? stretchyReport.getReportName() : null;
                    HashMap reportStretchyParams = this.reportMailingJobValidator.validateStretchyReportParamMap(emailCampaign.getStretchyReportParamMap());
                    if (reportStretchyParams.containsKey("selectLoan") || reportStretchyParams.containsKey("loanId")) {
                        if (emailMessage.getClient() != null) {
                            List loans = this.loanRepository.findLoanByClientId((Long)emailMessage.getClient().getId());
                            reportParams = this.replaceStretchyParamsWithActualClientParams(reportStretchyParams, emailMessage.getClient());
                            for (Loan loan : loans) {
                                if (!loan.isOpen()) continue;
                                if (reportStretchyParams.containsKey("selectLoan")) {
                                    reportParams.put("SelectLoan", ((Long)loan.getId()).toString());
                                } else if (reportStretchyParams.containsKey("loanId")) {
                                    reportParams.put("loanId", ((Long)loan.getId()).toString());
                                }
                                file = this.generateAttachments(emailCampaign, emailAttachmentFileFormat, (Map)reportParams, reportName, errorLog);
                                if (file != null) {
                                    attachmentList.add(file);
                                    continue;
                                }
                                errorLog.append(reportParams);
                            }
                        }
                    } else if (reportStretchyParams.containsKey("savingId")) {
                        if (emailMessage.getClient() != null) {
                            List savingsAccounts = this.savingsAccountRepository.findSavingAccountByClientId((Long)emailMessage.getClient().getId());
                            reportParams = this.replaceStretchyParamsWithActualClientParams(reportStretchyParams, emailMessage.getClient());
                            for (SavingsAccount savingsAccount : savingsAccounts) {
                                if (!savingsAccount.isActive()) continue;
                                reportParams.put("savingId", ((Long)savingsAccount.getId()).toString());
                                file = this.generateAttachments(emailCampaign, emailAttachmentFileFormat, (Map)reportParams, reportName, errorLog);
                                if (file != null) {
                                    attachmentList.add(file);
                                    continue;
                                }
                                errorLog.append(reportParams);
                            }
                        }
                    } else if (emailMessage.getClient() != null) {
                        HashMap reportParams = this.replaceStretchyParamsWithActualClientParams(reportStretchyParams, emailMessage.getClient());
                        File file = this.generateAttachments(emailCampaign, emailAttachmentFileFormat, (Map)reportParams, reportName, errorLog);
                        if (file != null) {
                            attachmentList.add(file);
                        } else {
                            errorLog.append(reportParams);
                        }
                    }
                }
                EmailMessageWithAttachmentData emailMessageWithAttachmentData = EmailMessageWithAttachmentData.createNew((String)emailMessage.getEmailAddress(), (String)emailMessage.getMessage(), (String)emailMessage.getEmailSubject(), attachmentList);
                try {
                    this.emailMessageJobEmailService.sendEmailWithAttachment(emailMessageWithAttachmentData);
                    emailMessage.setStatusType(EmailMessageStatusType.SENT.getValue());
                    this.emailMessageRepository.save((Object)emailMessage);
                }
                catch (Exception e) {
                    emailMessage.setErrorMessage(e.getMessage());
                    emailMessage.setStatusType(EmailMessageStatusType.FAILED.getValue());
                    this.emailMessageRepository.save((Object)emailMessage);
                }
            }
        }
        return RepeatStatus.FINISHED;
    }

    public static boolean isValidEmail(String email) {
        boolean isValid = true;
        try {
            InternetAddress emailO = new InternetAddress(email);
            emailO.validate();
        }
        catch (AddressException ex) {
            isValid = false;
        }
        return isValid;
    }

    private HashMap<String, String> replaceStretchyParamsWithActualClientParams(HashMap<String, String> stretchyParams, Client client) {
        HashMap<String, String> actualParams = new HashMap<String, String>();
        block12: for (Map.Entry<String, String> entry : stretchyParams.entrySet()) {
            switch (entry.getKey()) {
                case "selectOffice": {
                    if (client.getStaff() != null) {
                        actualParams.put(entry.getKey(), client.getStaff().officeId().toString());
                        continue block12;
                    }
                    actualParams.put(entry.getKey(), ((Long)client.getOffice().getId()).toString());
                    continue block12;
                }
                case "selectClient": {
                    actualParams.put(entry.getKey(), ((Long)client.getId()).toString());
                    continue block12;
                }
                case "selectLoanofficer": {
                    actualParams.put(entry.getKey(), ((Long)client.getStaff().getId()).toString());
                    continue block12;
                }
                case "environementUrl": {
                    actualParams.put(entry.getKey(), entry.getKey());
                    continue block12;
                }
            }
            log.warn("Query parameter could not be mapped: {}", (Object)entry.getKey());
        }
        return actualParams;
    }

    private File generateAttachments(EmailCampaign emailCampaign, ScheduledEmailAttachmentFileFormat emailAttachmentFileFormat, Map<String, String> reportParams, String reportName, StringBuilder errorLog) {
        if (reportName == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.readReportingService.generatePentahoReportAsOutputStream(reportName, emailAttachmentFileFormat.getValue(), reportParams, null, emailCampaign.getApprovedBy(), errorLog);
            String fileLocation = this.fineractProperties.getContent().getFilesystem().getRootFolder() + File.separator;
            String fileNameWithoutExtension = fileLocation + File.separator + reportName;
            if (!new File(fileLocation).isDirectory()) {
                new File(fileLocation).mkdirs();
            }
            if (byteArrayOutputStream.size() == 0) {
                errorLog.append("Pentaho report processing failed, empty output stream created");
            } else if (errorLog.length() == 0 && byteArrayOutputStream.size() > 0) {
                String fileName = fileNameWithoutExtension + "." + emailAttachmentFileFormat.getValue();
                File file = new File(fileName);
                FileOutputStream outputStream = new FileOutputStream(file);
                byteArrayOutputStream.writeTo(outputStream);
                return file;
            }
        }
        catch (IOException | PlatformDataIntegrityException e) {
            errorLog.append("The ReportMailingJobWritePlatformServiceImpl.executeReportMailingJobs threw an IOException exception: ").append(e.getMessage()).append(" ---------- ");
        }
        return null;
    }

    @Generated
    public ExecuteEmailTasklet(EmailMessageRepository emailMessageRepository, EmailCampaignRepository emailCampaignRepository, LoanRepository loanRepository, SavingsAccountRepository savingsAccountRepository, EmailMessageJobEmailService emailMessageJobEmailService, ReadReportingService readReportingService, ReportMailingJobValidator reportMailingJobValidator, FineractProperties fineractProperties) {
        this.emailMessageRepository = emailMessageRepository;
        this.emailCampaignRepository = emailCampaignRepository;
        this.loanRepository = loanRepository;
        this.savingsAccountRepository = savingsAccountRepository;
        this.emailMessageJobEmailService = emailMessageJobEmailService;
        this.readReportingService = readReportingService;
        this.reportMailingJobValidator = reportMailingJobValidator;
        this.fineractProperties = fineractProperties;
    }
}

