/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.instancemode.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.instancemode.api.InstanceModeApiResourceSwagger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component
@Path(value="/v1/instance-mode")
@Tag(name="Instance Mode", description="Instance mode changing API")
public class InstanceModeApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceModeApiResource.class);
    private final FineractProperties fineractProperties;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() throws Exception {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Instance type changing feature is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @PUT
    @Consumes(value={"application/json"})
    @Operation(summary="Changes the Fineract instance mode", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InstanceModeApiResourceSwagger.ChangeInstanceModeRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public Response changeMode(InstanceModeApiResourceSwagger.ChangeInstanceModeRequest request) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Changing instance mode according to the request parameters {}", (Object)request);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        this.fineractProperties.getMode().setReadEnabled(request.isReadEnabled());
        this.fineractProperties.getMode().setWriteEnabled(request.isWriteEnabled());
        this.fineractProperties.getMode().setBatchWorkerEnabled(request.isBatchWorkerEnabled());
        this.fineractProperties.getMode().setBatchManagerEnabled(request.isBatchManagerEnabled());
        return Response.ok().build();
    }

    @Generated
    public InstanceModeApiResource(FineractProperties fineractProperties) {
        this.fineractProperties = fineractProperties;
    }
}

