/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.StandingInstructionDataValidator;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetailRepository;
import org.apache.fineract.portfolio.account.domain.AccountTransferStandingInstruction;
import org.apache.fineract.portfolio.account.domain.StandingInstructionAssembler;
import org.apache.fineract.portfolio.account.domain.StandingInstructionRepository;
import org.apache.fineract.portfolio.account.domain.StandingInstructionStatus;
import org.apache.fineract.portfolio.account.exception.StandingInstructionNotFoundException;
import org.apache.fineract.portfolio.account.service.StandingInstructionWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class StandingInstructionWritePlatformServiceImpl
implements StandingInstructionWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandingInstructionWritePlatformServiceImpl.class);
    private final StandingInstructionDataValidator standingInstructionDataValidator;
    private final StandingInstructionAssembler standingInstructionAssembler;
    private final AccountTransferDetailRepository accountTransferDetailRepository;
    private final StandingInstructionRepository standingInstructionRepository;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        this.standingInstructionDataValidator.validateForCreate(command);
        Integer fromAccountTypeId = command.integerValueSansLocaleOfParameterNamed("fromAccountType");
        PortfolioAccountType fromAccountType = PortfolioAccountType.fromInt((Integer)fromAccountTypeId);
        Integer toAccountTypeId = command.integerValueSansLocaleOfParameterNamed("toAccountType");
        PortfolioAccountType toAccountType = PortfolioAccountType.fromInt((Integer)toAccountTypeId);
        Long fromClientId = command.longValueOfParameterNamed("fromClientId");
        Long standingInstructionId = null;
        try {
            if (this.isSavingsToSavingsAccountTransfer(fromAccountType, toAccountType)) {
                standingInstruction = this.standingInstructionAssembler.assembleSavingsToSavingsTransfer(command);
                this.accountTransferDetailRepository.saveAndFlush((Object)standingInstruction);
                standingInstructionId = (Long)standingInstruction.accountTransferStandingInstruction().getId();
            } else if (this.isSavingsToLoanAccountTransfer(fromAccountType, toAccountType)) {
                standingInstruction = this.standingInstructionAssembler.assembleSavingsToLoanTransfer(command);
                this.accountTransferDetailRepository.saveAndFlush((Object)standingInstruction);
                standingInstructionId = (Long)standingInstruction.accountTransferStandingInstruction().getId();
            } else if (this.isLoanToSavingsAccountTransfer(fromAccountType, toAccountType)) {
                standingInstruction = this.standingInstructionAssembler.assembleLoanToSavingsTransfer(command);
                this.accountTransferDetailRepository.saveAndFlush((Object)standingInstruction);
                standingInstructionId = (Long)standingInstruction.accountTransferStandingInstruction().getId();
            }
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
        CommandProcessingResultBuilder builder = new CommandProcessingResultBuilder().withEntityId(standingInstructionId).withClientId(fromClientId);
        return builder.build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.standinginstruction.duplicate.name", "Standinginstruction with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.client.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    private boolean isLoanToSavingsAccountTransfer(PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType) {
        return fromAccountType.isLoanAccount() && toAccountType.isSavingsAccount();
    }

    private boolean isSavingsToLoanAccountTransfer(PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType) {
        return fromAccountType.isSavingsAccount() && toAccountType.isLoanAccount();
    }

    private boolean isSavingsToSavingsAccountTransfer(PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType) {
        return fromAccountType.isSavingsAccount() && toAccountType.isSavingsAccount();
    }

    public CommandProcessingResult update(Long id, JsonCommand command) {
        this.standingInstructionDataValidator.validateForUpdate(command);
        AccountTransferStandingInstruction standingInstructionsForUpdate = (AccountTransferStandingInstruction)this.standingInstructionRepository.findById((Object)id).orElseThrow(() -> new StandingInstructionNotFoundException(id));
        Map actualChanges = standingInstructionsForUpdate.update(command);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(id).with(actualChanges).build();
    }

    public CommandProcessingResult delete(Long id) {
        AccountTransferStandingInstruction standingInstructionsForUpdate = (AccountTransferStandingInstruction)this.standingInstructionRepository.findById((Object)id).orElseThrow();
        standingInstructionsForUpdate.delete();
        HashMap<String, Integer> actualChanges = new HashMap<String, Integer>();
        actualChanges.put("status", StandingInstructionStatus.DELETED.getValue());
        return new CommandProcessingResultBuilder().withEntityId(id).with(actualChanges).build();
    }

    @Generated
    public StandingInstructionWritePlatformServiceImpl(StandingInstructionDataValidator standingInstructionDataValidator, StandingInstructionAssembler standingInstructionAssembler, AccountTransferDetailRepository accountTransferDetailRepository, StandingInstructionRepository standingInstructionRepository) {
        this.standingInstructionDataValidator = standingInstructionDataValidator;
        this.standingInstructionAssembler = standingInstructionAssembler;
        this.accountTransferDetailRepository = accountTransferDetailRepository;
        this.standingInstructionRepository = standingInstructionRepository;
    }
}

