/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import com.google.gson.JsonElement;
import jakarta.persistence.PersistenceException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandProcessingService;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.client.ClientActivateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.client.ClientCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.client.ClientRejectBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.address.service.AddressWritePlatformService;
import org.apache.fineract.portfolio.client.data.ClientDataValidator;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientEnumerations;
import org.apache.fineract.portfolio.client.domain.ClientNonPerson;
import org.apache.fineract.portfolio.client.domain.ClientNonPersonRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientStatus;
import org.apache.fineract.portfolio.client.domain.LegalForm;
import org.apache.fineract.portfolio.client.exception.ClientActiveForUpdateException;
import org.apache.fineract.portfolio.client.exception.ClientHasNoStaffException;
import org.apache.fineract.portfolio.client.exception.ClientMustBePendingToBeDeletedException;
import org.apache.fineract.portfolio.client.exception.InvalidClientSavingProductException;
import org.apache.fineract.portfolio.client.exception.InvalidClientStateTransitionException;
import org.apache.fineract.portfolio.client.service.ClientFamilyMembersWritePlatformService;
import org.apache.fineract.portfolio.client.service.ClientWritePlatformService;
import org.apache.fineract.portfolio.client.service.LoanStatusMapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.group.exception.GroupMemberCountNotInPermissibleRangeException;
import org.apache.fineract.portfolio.group.exception.GroupNotFoundException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.savings.data.SavingsAccountDataDTO;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsProductRepository;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsApplicationProcessWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClientWritePlatformServiceJpaRepositoryImpl
implements ClientWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final ClientRepositoryWrapper clientRepository;
    private final ClientNonPersonRepositoryWrapper clientNonPersonRepository;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final NoteRepository noteRepository;
    private final GroupRepository groupRepository;
    private final ClientDataValidator fromApiJsonDeserializer;
    private final AccountNumberGenerator accountNumberGenerator;
    private final StaffRepositoryWrapper staffRepository;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final SavingsAccountRepositoryWrapper savingsRepositoryWrapper;
    private final SavingsProductRepository savingsProductRepository;
    private final SavingsApplicationProcessWritePlatformService savingsApplicationProcessWritePlatformService;
    private final CommandProcessingService commandProcessingService;
    private final ConfigurationDomainService configurationDomainService;
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final FromJsonHelper fromApiJsonHelper;
    private final AddressWritePlatformService addressWritePlatformService;
    private final ClientFamilyMembersWritePlatformService clientFamilyMembersWritePlatformService;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final ExternalIdFactory externalIdFactory;

    @Transactional
    public CommandProcessingResult deleteClient(Long clientId) {
        try {
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            if (client.isNotPending()) {
                throw new ClientMustBePendingToBeDeletedException(clientId);
            }
            List relatedNotes = this.noteRepository.findByClient(client);
            this.noteRepository.deleteAllInBatch((Iterable)relatedNotes);
            ClientNonPerson clientNonPerson = this.clientNonPersonRepository.findOneByClientId(clientId);
            if (clientNonPerson != null) {
                this.clientNonPersonRepository.delete(clientNonPerson);
            }
            this.clientRepository.delete(client);
            this.clientRepository.flush();
            return new CommandProcessingResultBuilder().withOfficeId(client.officeId()).withEntityExternalId(client.getExternalId()).withClientId(clientId).withEntityId(clientId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            log.error("Error occured.", throwable);
            throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.client.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
        }
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("external_id")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            throw new PlatformDataIntegrityException("error.msg.client.duplicate.externalId", "Client with externalId `" + externalId + "` already exists", "externalId", new Object[]{externalId});
        }
        if (realCause.getMessage().contains("account_no_UNIQUE")) {
            String accountNo = command.stringValueOfParameterNamed("accountNo");
            throw new PlatformDataIntegrityException("error.msg.client.duplicate.accountNo", "Client with accountNo `" + accountNo + "` already exists", "accountNo", new Object[]{accountNo});
        }
        if (realCause.getMessage().contains("mobile_no")) {
            String mobileNo = command.stringValueOfParameterNamed("mobileNo");
            throw new PlatformDataIntegrityException("error.msg.client.duplicate.mobileNo", "Client with mobileNo `" + mobileNo + "` already exists", "mobileNo", new Object[]{mobileNo});
        }
        this.logAsErrorUnexpectedDataIntegrityException(dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.client.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Transactional
    public CommandProcessingResult createClient(JsonCommand command) {
        try {
            Long savingsProductId;
            AppUser currentUser = this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Boolean isAddressEnabled = this.configurationDomainService.isAddressEnabled();
            Long officeId = command.longValueOfParameterNamed("officeId");
            Office clientOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            Long groupId = command.longValueOfParameterNamed("groupId");
            Group clientParentGroup = null;
            if (groupId != null) {
                clientParentGroup = (Group)this.groupRepository.findById((Object)groupId).orElseThrow(() -> new GroupNotFoundException(groupId));
            }
            Staff staff = null;
            Long staffId = command.longValueOfParameterNamed("staffId");
            if (staffId != null) {
                staff = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(staffId, clientOffice.getHierarchy());
            }
            CodeValue gender = null;
            Long genderId = command.longValueOfParameterNamed("genderId");
            if (genderId != null) {
                gender = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("Gender", genderId);
            }
            CodeValue clientType = null;
            Long clientTypeId = command.longValueOfParameterNamed("clientTypeId");
            if (clientTypeId != null) {
                clientType = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ClientType", clientTypeId);
            }
            CodeValue clientClassification = null;
            Long clientClassificationId = command.longValueOfParameterNamed("clientClassificationId");
            if (clientClassificationId != null) {
                clientClassification = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ClientClassification", clientClassificationId);
            }
            if ((savingsProductId = command.longValueOfParameterNamed("savingsProductId")) != null) {
                this.savingsProductRepository.findById((Object)savingsProductId).orElseThrow(() -> new SavingsProductNotFoundException(savingsProductId));
            }
            boolean isEntity = false;
            LegalForm legalForm = null;
            Integer legalFormParamValue = command.integerValueOfParameterNamed("legalFormId");
            if (legalFormParamValue != null && (legalForm = LegalForm.fromInt((Integer)legalFormParamValue)) != null) {
                isEntity = legalForm.isEntity();
            }
            if (legalForm == null) {
                legalForm = LegalForm.PERSON;
            }
            String accountNo = command.stringValueOfParameterNamed("accountNo");
            String mobileNo = command.stringValueOfParameterNamed("mobileNo");
            String emailAddress = command.stringValueOfParameterNamed("emailAddress");
            String firstname = command.stringValueOfParameterNamed("firstname");
            String middlename = command.stringValueOfParameterNamed("middlename");
            String lastname = command.stringValueOfParameterNamed("lastname");
            String fullname = command.stringValueOfParameterNamed("fullname");
            boolean isStaff = command.booleanPrimitiveValueOfParameterNamed("isStaff");
            LocalDate dataOfBirth = command.localDateValueOfParameterNamed("dateOfBirth");
            ClientStatus status = ClientStatus.PENDING;
            boolean active = false;
            if (command.hasParameter("active")) {
                active = command.booleanPrimitiveValueOfParameterNamed("active");
            }
            LocalDate activationDate = null;
            LocalDate officeJoiningDate = null;
            if (active) {
                status = ClientStatus.ACTIVE;
                officeJoiningDate = activationDate = command.localDateValueOfParameterNamed("activationDate");
            }
            LocalDate submittedOnDate = DateUtils.getBusinessLocalDate();
            if (command.hasParameter("submittedOnDate")) {
                submittedOnDate = command.localDateValueOfParameterNamed("submittedOnDate");
            }
            if (active && DateUtils.isAfter((LocalDate)submittedOnDate, (LocalDate)activationDate)) {
                submittedOnDate = activationDate;
            }
            Long savingsAccountId = null;
            ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
            Client newClient = Client.instance((AppUser)currentUser, (ClientStatus)status, (Office)clientOffice, (Group)clientParentGroup, (String)accountNo, (String)firstname, (String)middlename, (String)lastname, (String)fullname, (LocalDate)activationDate, (LocalDate)officeJoiningDate, (ExternalId)externalId, (String)mobileNo, (String)emailAddress, (Staff)staff, (LocalDate)submittedOnDate, (Long)savingsProductId, savingsAccountId, (LocalDate)dataOfBirth, (CodeValue)gender, (CodeValue)clientType, (CodeValue)clientClassification, (Integer)legalForm.getValue(), (Boolean)isStaff);
            this.clientRepository.saveAndFlush(newClient);
            if (StringUtils.isBlank((CharSequence)accountNo)) {
                AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.CLIENT);
                newClient.updateAccountNo(this.accountNumberGenerator.generate(newClient, accountNumberFormat));
                this.clientRepository.saveAndFlush(newClient);
            }
            boolean rollbackTransaction = false;
            if (newClient.isActive()) {
                this.validateParentGroupRulesBeforeClientActivation(newClient);
                this.runEntityDatatableCheck((Long)newClient.getId(), newClient.getLegalForm());
                CommandWrapper commandWrapper = new CommandWrapperBuilder().activateClient(null).build();
                rollbackTransaction = this.commandProcessingService.validateRollbackCommand(commandWrapper, currentUser);
            }
            this.clientRepository.saveAndFlush(newClient);
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            CommandProcessingResult result = this.openSavingsAccount(newClient, fmt);
            if (result.getSavingsId() != null) {
                this.clientRepository.saveAndFlush(newClient);
            }
            if (isEntity) {
                this.extractAndCreateClientNonPerson(newClient, command);
            }
            if (isAddressEnabled.booleanValue()) {
                this.addressWritePlatformService.addNewClientAddress(newClient, command);
            }
            if (command.arrayOfParameterNamed("familyMembers") != null) {
                this.clientFamilyMembersWritePlatformService.addClientFamilyMember(newClient, command);
            }
            if (command.parameterExists("datatables")) {
                this.entityDatatableChecksWritePlatformService.saveDatatables(StatusEnum.CREATE.getValue(), EntityTables.CLIENT.getName(), (Long)newClient.getId(), null, command.arrayOfParameterNamed("datatables"));
            }
            legalForm = LegalForm.fromInt((Integer)newClient.getLegalForm());
            this.entityDatatableChecksWritePlatformService.runTheCheck((Long)newClient.getId(), EntityTables.CLIENT.getName(), StatusEnum.CREATE.getValue(), EntityTables.CLIENT.getForeignKeyColumnNameOnDatatable(), legalForm.getLabel());
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new ClientCreateBusinessEvent(newClient));
            if (newClient.isActive()) {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new ClientActivateBusinessEvent(newClient));
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityExternalId(newClient.getExternalId()).withOfficeId((Long)clientOffice.getId()).withClientId((Long)newClient.getId()).withGroupId(groupId).withEntityId((Long)newClient.getId()).withSavingsId(result.getSavingsId()).setRollbackTransaction(rollbackTransaction).setRollbackTransaction(result.isRollbackTransaction()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    public void extractAndCreateClientNonPerson(Client client, JsonCommand command) {
        JsonElement clientNonPersonElement = this.fromApiJsonHelper.parse(command.jsonFragment("clientNonPersonDetails"));
        if (clientNonPersonElement != null && !this.isEmpty(clientNonPersonElement)) {
            String incorpNumber = this.fromApiJsonHelper.extractStringNamed("incorpNumber", clientNonPersonElement);
            String remarks = this.fromApiJsonHelper.extractStringNamed("remarks", clientNonPersonElement);
            LocalDate incorpValidityTill = this.fromApiJsonHelper.extractLocalDateNamed("incorpValidityTillDate", clientNonPersonElement);
            CodeValue clientNonPersonConstitution = null;
            Long clientNonPersonConstitutionId = this.fromApiJsonHelper.extractLongNamed("constitutionId", clientNonPersonElement);
            if (clientNonPersonConstitutionId != null) {
                clientNonPersonConstitution = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("Constitution", clientNonPersonConstitutionId);
            }
            CodeValue clientNonPersonMainBusinessLine = null;
            Long clientNonPersonMainBusinessLineId = this.fromApiJsonHelper.extractLongNamed("mainBusinessLineId", clientNonPersonElement);
            if (clientNonPersonMainBusinessLineId != null) {
                clientNonPersonMainBusinessLine = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("Main Business Line", clientNonPersonMainBusinessLineId);
            }
            ClientNonPerson newClientNonPerson = ClientNonPerson.createNew((Client)client, (CodeValue)clientNonPersonConstitution, (CodeValue)clientNonPersonMainBusinessLine, (String)incorpNumber, (LocalDate)incorpValidityTill, (String)remarks);
            this.clientNonPersonRepository.save(newClientNonPerson);
        }
    }

    public boolean isEmpty(JsonElement element) {
        return element.toString().trim().length() < 4;
    }

    @Transactional
    public CommandProcessingResult updateClient(Long clientId, JsonCommand command) {
        try {
            ClientNonPerson clientNonPersonForUpdate;
            CodeValue newCodeVal;
            Long newValue;
            String valueAsInput;
            Object newValue2;
            Object newValue3;
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            Client clientForUpdate = this.clientRepository.findOneWithNotFoundDetection(clientId);
            String clientHierarchy = clientForUpdate.getOffice().getHierarchy();
            this.context.validateAccessRights(clientHierarchy);
            LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>(9);
            if (command.isChangeInIntegerParameterNamed("status", clientForUpdate.getStatus())) {
                newValue3 = command.integerValueOfParameterNamed("status");
                changes.put("status", ClientEnumerations.status((Integer)newValue3));
                clientForUpdate.setStatus(ClientStatus.fromInt((Integer)newValue3).getValue());
            }
            if (command.isChangeInStringParameterNamed("accountNo", clientForUpdate.getAccountNumber())) {
                newValue3 = command.stringValueOfParameterNamed("accountNo");
                changes.put("accountNo", newValue3);
                clientForUpdate.setAccountNumber((String)StringUtils.defaultIfEmpty((CharSequence)newValue3, null));
            }
            ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
            if (command.isChangeInStringParameterNamed("externalId", clientForUpdate.getExternalId().getValue())) {
                changes.put("externalId", externalId.getValue());
                clientForUpdate.setExternalId(externalId);
            }
            if (command.isChangeInStringParameterNamed("mobileNo", clientForUpdate.getMobileNo())) {
                newValue2 = command.stringValueOfParameterNamed("mobileNo");
                changes.put("mobileNo", newValue2);
                clientForUpdate.setMobileNo((String)StringUtils.defaultIfEmpty((CharSequence)newValue2, null));
            }
            if (command.isChangeInStringParameterNamed("emailAddress", clientForUpdate.getEmailAddress())) {
                newValue2 = command.stringValueOfParameterNamed("emailAddress");
                changes.put("emailAddress", newValue2);
                clientForUpdate.setEmailAddress((String)StringUtils.defaultIfEmpty((CharSequence)newValue2, null));
            }
            if (command.isChangeInStringParameterNamed("firstname", clientForUpdate.getFirstname())) {
                newValue2 = command.stringValueOfParameterNamed("firstname");
                changes.put("firstname", newValue2);
                clientForUpdate.setFirstname((String)StringUtils.defaultIfEmpty((CharSequence)newValue2, null));
            }
            if (command.isChangeInStringParameterNamed("middlename", clientForUpdate.getMiddlename())) {
                newValue2 = command.stringValueOfParameterNamed("middlename");
                changes.put("middlename", newValue2);
                clientForUpdate.setMiddlename((String)StringUtils.defaultIfEmpty((CharSequence)newValue2, null));
            }
            if (command.isChangeInStringParameterNamed("lastname", clientForUpdate.getLastname())) {
                newValue2 = command.stringValueOfParameterNamed("lastname");
                changes.put("lastname", newValue2);
                clientForUpdate.setLastname((String)StringUtils.defaultIfEmpty((CharSequence)newValue2, null));
            }
            if (command.isChangeInStringParameterNamed("fullname", clientForUpdate.getFullname())) {
                newValue2 = command.stringValueOfParameterNamed("fullname");
                changes.put("fullname", newValue2);
                clientForUpdate.setFullname((String)newValue2);
            }
            if (command.isChangeInLongParameterNamed("staffId", clientForUpdate.staffId())) {
                newValue2 = command.longValueOfParameterNamed("staffId");
                changes.put("staffId", newValue2);
            }
            if (command.isChangeInLongParameterNamed("genderId", clientForUpdate.genderId())) {
                newValue2 = command.longValueOfParameterNamed("genderId");
                changes.put("genderId", newValue2);
            }
            if (command.isChangeInLongParameterNamed("savingsProductId", clientForUpdate.savingsProductId())) {
                newValue2 = command.longValueOfParameterNamed("savingsProductId");
                changes.put("savingsProductId", newValue2);
            }
            if (command.isChangeInLongParameterNamed("clientTypeId", clientForUpdate.clientTypeId())) {
                newValue2 = command.longValueOfParameterNamed("clientTypeId");
                changes.put("clientTypeId", newValue2);
            }
            if (command.isChangeInLongParameterNamed("clientClassificationId", clientForUpdate.clientClassificationId())) {
                newValue2 = command.longValueOfParameterNamed("clientClassificationId");
                changes.put("clientClassificationId", newValue2);
            }
            if (command.isChangeInIntegerParameterNamed("legalFormId", clientForUpdate.getLegalForm())) {
                newValue2 = command.integerValueOfParameterNamed("legalFormId");
                if (newValue2 != null) {
                    LegalForm legalForm = LegalForm.fromInt((Integer)newValue2);
                    if (legalForm != null) {
                        changes.put("legalFormId", ClientEnumerations.legalForm((Integer)newValue2));
                        clientForUpdate.setLegalForm(legalForm.getValue());
                        clientForUpdate.resetDerivedNames(legalForm);
                    } else {
                        changes.put("legalFormId", null);
                        clientForUpdate.setLegalForm(null);
                    }
                } else {
                    changes.put("legalFormId", null);
                    clientForUpdate.setLegalForm(null);
                }
            }
            String dateFormatAsInput = command.dateFormat();
            String localeAsInput = command.locale();
            if (command.isChangeInLocalDateParameterNamed("activationDate", clientForUpdate.getActivationDate())) {
                valueAsInput = command.stringValueOfParameterNamed("activationDate");
                changes.put("activationDate", valueAsInput);
                changes.put("dateFormat", dateFormatAsInput);
                changes.put("locale", localeAsInput);
                clientForUpdate.setActivationDate(command.localDateValueOfParameterNamed("activationDate"));
                clientForUpdate.setOfficeJoiningDate(clientForUpdate.getActivationDate());
            }
            if (command.isChangeInLocalDateParameterNamed("dateOfBirth", clientForUpdate.getDateOfBirth())) {
                valueAsInput = command.stringValueOfParameterNamed("dateOfBirth");
                changes.put("dateOfBirth", valueAsInput);
                changes.put("dateFormat", dateFormatAsInput);
                changes.put("locale", localeAsInput);
                clientForUpdate.setDateOfBirth(command.localDateValueOfParameterNamed("dateOfBirth"));
            }
            if (command.isChangeInLocalDateParameterNamed("submittedOnDate", clientForUpdate.getSubmittedOnDate())) {
                valueAsInput = command.stringValueOfParameterNamed("submittedOnDate");
                changes.put("submittedOnDate", valueAsInput);
                changes.put("dateFormat", dateFormatAsInput);
                changes.put("locale", localeAsInput);
                clientForUpdate.setSubmittedOnDate(command.localDateValueOfParameterNamed("submittedOnDate"));
            }
            clientForUpdate.validateUpdate();
            clientForUpdate.deriveDisplayName();
            if (changes.containsKey("staffId")) {
                newValue = command.longValueOfParameterNamed("staffId");
                Staff newStaff = null;
                if (newValue != null) {
                    newStaff = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(newValue, clientForUpdate.getOffice().getHierarchy());
                }
                clientForUpdate.updateStaff(newStaff);
            }
            if (changes.containsKey("genderId")) {
                newValue = command.longValueOfParameterNamed("genderId");
                CodeValue gender = null;
                if (newValue != null) {
                    gender = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("Gender", newValue);
                }
                clientForUpdate.updateGender(gender);
            }
            if (changes.containsKey("savingsProductId")) {
                if (clientForUpdate.isActive()) {
                    throw new ClientActiveForUpdateException(clientId, "savingsProductId");
                }
                Long savingsProductId = command.longValueOfParameterNamed("savingsProductId");
                if (savingsProductId != null) {
                    this.savingsProductRepository.findById((Object)savingsProductId).orElseThrow(() -> new SavingsProductNotFoundException(savingsProductId));
                }
                clientForUpdate.updateSavingsProduct(savingsProductId);
            }
            if (changes.containsKey("genderId")) {
                newValue = command.longValueOfParameterNamed("genderId");
                newCodeVal = null;
                if (newValue != null) {
                    newCodeVal = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("Gender", newValue);
                }
                clientForUpdate.updateGender(newCodeVal);
            }
            if (changes.containsKey("clientTypeId")) {
                newValue = command.longValueOfParameterNamed("clientTypeId");
                newCodeVal = null;
                if (newValue != null) {
                    newCodeVal = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ClientType", newValue);
                }
                clientForUpdate.updateClientType(newCodeVal);
            }
            if (changes.containsKey("clientClassificationId")) {
                newValue = command.longValueOfParameterNamed("clientClassificationId");
                newCodeVal = null;
                if (newValue != null) {
                    newCodeVal = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ClientClassification", newValue);
                }
                clientForUpdate.updateClientClassification(newCodeVal);
            }
            if (!changes.isEmpty()) {
                this.clientRepository.saveAndFlush(clientForUpdate);
            }
            if (changes.containsKey("legalFormId")) {
                LegalForm legalForm;
                Integer legalFormValue = clientForUpdate.getLegalForm();
                boolean isChangedToEntity = false;
                if (legalFormValue != null && (legalForm = LegalForm.fromInt((Integer)legalFormValue)) != null) {
                    isChangedToEntity = legalForm.isEntity();
                }
                if (isChangedToEntity) {
                    this.extractAndCreateClientNonPerson(clientForUpdate, command);
                } else {
                    ClientNonPerson clientNonPerson = this.clientNonPersonRepository.findOneByClientId((Long)clientForUpdate.getId());
                    if (clientNonPerson != null) {
                        this.clientNonPersonRepository.delete(clientNonPerson);
                    }
                }
            }
            if ((clientNonPersonForUpdate = this.clientNonPersonRepository.findOneByClientId(clientId)) != null) {
                Long newValue4;
                JsonElement clientNonPersonElement = command.jsonElement("clientNonPersonDetails");
                Map clientNonPersonChanges = clientNonPersonForUpdate.update(JsonCommand.fromExistingCommand((JsonCommand)command, (JsonElement)clientNonPersonElement));
                if (clientNonPersonChanges.containsKey("constitutionId")) {
                    newValue4 = this.fromApiJsonHelper.extractLongNamed("constitutionId", clientNonPersonElement);
                    CodeValue constitution = null;
                    if (newValue4 != null) {
                        constitution = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("Constitution", newValue4);
                    }
                    clientNonPersonForUpdate.updateConstitution(constitution);
                }
                if (clientNonPersonChanges.containsKey("mainBusinessLineId")) {
                    newValue4 = this.fromApiJsonHelper.extractLongNamed("mainBusinessLineId", clientNonPersonElement);
                    CodeValue mainBusinessLine = null;
                    if (newValue4 != null) {
                        mainBusinessLine = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("Main Business Line", newValue4);
                    }
                    clientNonPersonForUpdate.updateMainBusinessLine(mainBusinessLine);
                }
                if (!clientNonPersonChanges.isEmpty()) {
                    this.clientNonPersonRepository.saveAndFlush(clientNonPersonForUpdate);
                }
                changes.putAll(clientNonPersonChanges);
            } else {
                LegalForm legalForm;
                Integer legalFormParamValue = command.integerValueOfParameterNamed("legalFormId");
                boolean isEntity = false;
                if (legalFormParamValue != null && (legalForm = LegalForm.fromInt((Integer)legalFormParamValue)) != null) {
                    isEntity = legalForm.isEntity();
                }
                if (isEntity) {
                    this.extractAndCreateClientNonPerson(clientForUpdate, command);
                }
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityExternalId(clientForUpdate.getExternalId()).withOfficeId(clientForUpdate.officeId()).withClientId(clientId).withEntityId(clientId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult activateClient(Long clientId, JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateActivation(command);
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId, true);
            this.validateParentGroupRulesBeforeClientActivation(client);
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            LocalDate activationDate = command.localDateValueOfParameterNamed("activationDate");
            this.runEntityDatatableCheck(clientId, client.getLegalForm());
            AppUser currentUser = this.context.authenticatedUser();
            client.activate(currentUser, fmt, activationDate);
            CommandProcessingResult result = this.openSavingsAccount(client, fmt);
            this.clientRepository.saveAndFlush(client);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new ClientActivateBusinessEvent(client));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(client.officeId()).withEntityExternalId(client.getExternalId()).withClientId(clientId).withEntityId(clientId).withSavingsId(result.getSavingsId()).setRollbackTransaction(result.isRollbackTransaction()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    private CommandProcessingResult openSavingsAccount(Client client, DateTimeFormatter fmt) {
        SavingsAccountDataDTO savingsAccountDataDTO;
        CommandProcessingResult commandProcessingResult = CommandProcessingResult.empty();
        if (client.isActive() && client.savingsProductId() != null && (commandProcessingResult = this.savingsApplicationProcessWritePlatformService.createActiveApplication(savingsAccountDataDTO = new SavingsAccountDataDTO(client, null, client.savingsProductId(), client.getActivationDate(), client.activatedBy(), fmt))).getSavingsId() != null) {
            this.savingsRepositoryWrapper.findOneWithNotFoundDetection(commandProcessingResult.getSavingsId());
            client.updateSavingsAccount(commandProcessingResult.getSavingsId());
            client.updateSavingsProduct(null);
        }
        return commandProcessingResult;
    }

    private void logAsErrorUnexpectedDataIntegrityException(Exception dve) {
        log.error("Error occured.", (Throwable)dve);
    }

    @Transactional
    public CommandProcessingResult unassignClientStaff(Long clientId, JsonCommand command) {
        this.context.authenticatedUser();
        LinkedHashMap<String, Long> actualChanges = new LinkedHashMap<String, Long>(5);
        this.fromApiJsonDeserializer.validateForUnassignStaff(command.json());
        Client clientForUpdate = this.clientRepository.findOneWithNotFoundDetection(clientId);
        Staff presentStaff = clientForUpdate.getStaff();
        Long presentStaffId = null;
        if (presentStaff == null) {
            throw new ClientHasNoStaffException(clientId);
        }
        presentStaffId = (Long)presentStaff.getId();
        String staffIdParamName = "staffId";
        if (!command.isChangeInLongParameterNamed("staffId", presentStaffId)) {
            clientForUpdate.unassignStaff();
        }
        this.clientRepository.saveAndFlush(clientForUpdate);
        actualChanges.put("staffId", presentStaffId);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(clientForUpdate.officeId()).withEntityId((Long)clientForUpdate.getId()).withEntityExternalId(clientForUpdate.getExternalId()).withClientId(clientId).with(actualChanges).build();
    }

    public CommandProcessingResult assignClientStaff(Long clientId, JsonCommand command) {
        this.context.authenticatedUser();
        LinkedHashMap<String, Long> actualChanges = new LinkedHashMap<String, Long>(5);
        this.fromApiJsonDeserializer.validateForAssignStaff(command.json());
        Client clientForUpdate = this.clientRepository.findOneWithNotFoundDetection(clientId);
        Staff staff = null;
        Long staffId = command.longValueOfParameterNamed("staffId");
        if (staffId != null) {
            staff = this.staffRepository.findByOfficeHierarchyWithNotFoundDetection(staffId, clientForUpdate.getOffice().getHierarchy());
            clientForUpdate.assignStaff(staff);
        }
        this.clientRepository.saveAndFlush(clientForUpdate);
        actualChanges.put("staffId", staffId);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(clientForUpdate.officeId()).withEntityExternalId(clientForUpdate.getExternalId()).withEntityId((Long)clientForUpdate.getId()).withClientId(clientId).with(actualChanges).build();
    }

    @Transactional
    public CommandProcessingResult closeClient(Long clientId, JsonCommand command) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateClose(command);
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            LocalDate closureDate = command.localDateValueOfParameterNamed("closureDate");
            Long closureReasonId = command.longValueOfParameterNamed("closureReasonId");
            CodeValue closureReason = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ClientClosureReason", closureReasonId);
            if (ClientStatus.fromInt((Integer)client.getStatus()).isClosed()) {
                String errorMessage = "Client is already closed.";
                throw new InvalidClientStateTransitionException("close", "is.already.closed", "Client is already closed.", new Object[0]);
            }
            if (ClientStatus.fromInt((Integer)client.getStatus()).isUnderTransfer()) {
                String errorMessage = "Cannot Close a Client under Transfer";
                throw new InvalidClientStateTransitionException("close", "is.under.transfer", "Cannot Close a Client under Transfer", new Object[0]);
            }
            if (client.isNotPending() && DateUtils.isAfter((LocalDate)client.getActivationDate(), (LocalDate)closureDate)) {
                String errorMessage = "The client closureDate cannot be before the client ActivationDate.";
                throw new InvalidClientStateTransitionException("close", "date.cannot.before.client.actvation.date", "The client closureDate cannot be before the client ActivationDate.", new Object[]{closureDate, client.getActivationDate()});
            }
            LegalForm legalForm = LegalForm.fromInt((Integer)client.getLegalForm());
            this.entityDatatableChecksWritePlatformService.runTheCheck(clientId, EntityTables.CLIENT.getName(), StatusEnum.CLOSE.getValue(), EntityTables.CLIENT.getForeignKeyColumnNameOnDatatable(), legalForm.getLabel());
            List clientLoans = this.loanRepositoryWrapper.findLoanByClientId(clientId);
            for (Loan loan : clientLoans) {
                LoanStatusMapper loanStatus = new LoanStatusMapper(loan.getStatus().getValue());
                if (loanStatus.isOpen() || loanStatus.isPendingApproval() || loanStatus.isAwaitingDisbursal()) {
                    String errorMessage = "Client cannot be closed because of non-closed loans.";
                    throw new InvalidClientStateTransitionException("close", "loan.non-closed", "Client cannot be closed because of non-closed loans.", new Object[0]);
                }
                if (loanStatus.isClosed() && DateUtils.isAfter((LocalDate)loan.getClosedOnDate(), (LocalDate)closureDate)) {
                    String errorMessage = "The client closureDate cannot be before the loan closedOnDate.";
                    throw new InvalidClientStateTransitionException("close", "date.cannot.before.loan.closed.date", "The client closureDate cannot be before the loan closedOnDate.", new Object[]{closureDate, loan.getClosedOnDate()});
                }
                if (!loanStatus.isOverpaid()) continue;
                String errorMessage = "Client cannot be closed because of overpaid loans.";
                throw new InvalidClientStateTransitionException("close", "loan.overpaid", "Client cannot be closed because of overpaid loans.", new Object[0]);
            }
            List clientSavingAccounts = this.savingsRepositoryWrapper.findSavingAccountByClientId(clientId);
            for (SavingsAccount saving : clientSavingAccounts) {
                if (!saving.isActive() && !saving.isSubmittedAndPendingApproval() && !saving.isApproved()) continue;
                String errorMessage = "Client cannot be closed because of non-closed savings account.";
                throw new InvalidClientStateTransitionException("close", "non-closed.savings.account", "Client cannot be closed because of non-closed savings account.", new Object[0]);
            }
            client.close(currentUser, closureReason, closureDate);
            this.clientRepository.saveAndFlush(client);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withClientId(clientId).withEntityId(clientId).withEntityExternalId(client.getExternalId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult updateDefaultSavingsAccount(Long clientId, JsonCommand command) {
        this.context.authenticatedUser();
        LinkedHashMap<String, Long> actualChanges = new LinkedHashMap<String, Long>(5);
        this.fromApiJsonDeserializer.validateForSavingsAccount(command.json());
        Client clientForUpdate = this.clientRepository.findOneWithNotFoundDetection(clientId);
        SavingsAccount savingsAccount = null;
        Long savingsId = command.longValueOfParameterNamed("savingsAccountId");
        if (savingsId != null) {
            savingsAccount = this.savingsRepositoryWrapper.findOneWithNotFoundDetection(savingsId);
            if (!savingsAccount.getClient().identifiedBy(clientId)) {
                String defaultUserMessage = "saving account must belongs to client";
                throw new InvalidClientSavingProductException("saving.account", "must.belongs.to.client", defaultUserMessage, new Object[]{savingsId, clientForUpdate.getId()});
            }
            clientForUpdate.updateSavingsAccount(savingsId);
        }
        this.clientRepository.saveAndFlush(clientForUpdate);
        actualChanges.put("savingsAccountId", savingsId);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(clientForUpdate.officeId()).withEntityId((Long)clientForUpdate.getId()).withEntityExternalId(clientForUpdate.getExternalId()).withClientId(clientId).with(actualChanges).build();
    }

    private void validateParentGroupRulesBeforeClientActivation(Client client) {
        Integer minNumberOfClients = this.configurationDomainService.retrieveMinAllowedClientsInGroup();
        Integer maxNumberOfClients = this.configurationDomainService.retrieveMaxAllowedClientsInGroup();
        if (client.getGroups() != null && maxNumberOfClients != null) {
            for (Group group : client.getGroups()) {
                boolean validationsuccess = group.isGroupsClientCountWithinMaxRange(Integer.valueOf(maxNumberOfClients - 1));
                if (validationsuccess) continue;
                throw new GroupMemberCountNotInPermissibleRangeException((Long)group.getId(), minNumberOfClients, maxNumberOfClients);
            }
        }
    }

    private void runEntityDatatableCheck(Long clientId, Integer legalFormId) {
        LegalForm legalForm = LegalForm.fromInt((Integer)legalFormId);
        this.entityDatatableChecksWritePlatformService.runTheCheck(clientId, EntityTables.CLIENT.getName(), StatusEnum.ACTIVATE.getValue(), EntityTables.CLIENT.getForeignKeyColumnNameOnDatatable(), legalForm.getLabel());
    }

    public CommandProcessingResult rejectClient(Long entityId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateRejection(command);
        Client client = this.clientRepository.findOneWithNotFoundDetection(entityId);
        LocalDate rejectionDate = command.localDateValueOfParameterNamed("rejectionDate");
        Long rejectionReasonId = command.longValueOfParameterNamed("rejectionReasonId");
        CodeValue rejectionReason = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ClientRejectReason", rejectionReasonId);
        if (client.isNotPending()) {
            String errorMessage = "Only clients pending activation may be withdrawn.";
            throw new InvalidClientStateTransitionException("rejection", "on.account.not.in.pending.activation.status", "Only clients pending activation may be withdrawn.", new Object[]{rejectionDate, client.getSubmittedOnDate()});
        }
        if (DateUtils.isAfter((LocalDate)client.getSubmittedOnDate(), (LocalDate)rejectionDate)) {
            String errorMessage = "The client rejection date cannot be before the client submitted date.";
            throw new InvalidClientStateTransitionException("rejection", "date.cannot.before.client.submitted.date", "The client rejection date cannot be before the client submitted date.", new Object[]{rejectionDate, client.getSubmittedOnDate()});
        }
        client.reject(currentUser, rejectionReason, rejectionDate);
        this.clientRepository.saveAndFlush(client);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new ClientRejectBusinessEvent(client));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withClientId(entityId).withEntityId(entityId).withEntityExternalId(client.getExternalId()).build();
    }

    public CommandProcessingResult withdrawClient(Long entityId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateWithdrawn(command);
        Client client = this.clientRepository.findOneWithNotFoundDetection(entityId);
        LocalDate withdrawalDate = command.localDateValueOfParameterNamed("withdrawalDate");
        Long withdrawalReasonId = command.longValueOfParameterNamed("withdrawalReasonId");
        CodeValue withdrawalReason = this.codeValueRepository.findOneByCodeNameAndIdWithNotFoundDetection("ClientWithdrawReason", withdrawalReasonId);
        if (client.isNotPending()) {
            String errorMessage = "Only clients pending activation may be withdrawn.";
            throw new InvalidClientStateTransitionException("withdrawal", "on.account.not.in.pending.activation.status", "Only clients pending activation may be withdrawn.", new Object[]{withdrawalDate, client.getSubmittedOnDate()});
        }
        if (DateUtils.isAfter((LocalDate)client.getSubmittedOnDate(), (LocalDate)withdrawalDate)) {
            String errorMessage = "The client withdrawal date cannot be before the client submitted date.";
            throw new InvalidClientStateTransitionException("withdrawal", "date.cannot.before.client.submitted.date", "The client withdrawal date cannot be before the client submitted date.", new Object[]{withdrawalDate, client.getSubmittedOnDate()});
        }
        client.withdraw(currentUser, withdrawalReason, withdrawalDate);
        this.clientRepository.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withClientId(entityId).withEntityId(entityId).withEntityExternalId(client.getExternalId()).build();
    }

    public CommandProcessingResult reActivateClient(Long entityId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateReactivate(command);
        Client client = this.clientRepository.findOneWithNotFoundDetection(entityId);
        LocalDate reactivateDate = command.localDateValueOfParameterNamed("reactivationDate");
        if (!client.isClosed()) {
            String errorMessage = "only closed clients may be reactivated.";
            throw new InvalidClientStateTransitionException("reactivation", "on.nonclosed.account", "only closed clients may be reactivated.", new Object[0]);
        }
        if (DateUtils.isAfter((LocalDate)client.getClosureDate(), (LocalDate)reactivateDate)) {
            String errorMessage = "The client reactivation date cannot be before the client closed date.";
            throw new InvalidClientStateTransitionException("reactivation", "date.cannot.before.client.closed.date", "The client reactivation date cannot be before the client closed date.", new Object[]{reactivateDate, client.getClosureDate()});
        }
        client.reActivate(currentUser, reactivateDate);
        this.clientRepository.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withClientId(entityId).withEntityId(entityId).withEntityExternalId(client.getExternalId()).build();
    }

    public CommandProcessingResult undoRejection(Long entityId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateUndoRejection(command);
        Client client = this.clientRepository.findOneWithNotFoundDetection(entityId);
        LocalDate undoRejectDate = command.localDateValueOfParameterNamed("reopenedDate");
        if (!client.isRejected()) {
            String errorMessage = "only rejected clients may be reactivated.";
            throw new InvalidClientStateTransitionException("undorejection", "on.nonrejected.account", "only rejected clients may be reactivated.", new Object[0]);
        }
        if (DateUtils.isAfter((LocalDate)client.getRejectedDate(), (LocalDate)undoRejectDate)) {
            String errorMessage = "The client reactivation date cannot be before the client rejected date.";
            throw new InvalidClientStateTransitionException("reopened", "date.cannot.before.client.rejected.date", "The client reactivation date cannot be before the client rejected date.", new Object[]{undoRejectDate, client.getRejectedDate()});
        }
        client.reOpened(currentUser, undoRejectDate);
        this.clientRepository.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withClientId(entityId).withEntityId(entityId).withEntityExternalId(client.getExternalId()).build();
    }

    public CommandProcessingResult undoWithdrawal(Long entityId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateUndoWithDrawn(command);
        Client client = this.clientRepository.findOneWithNotFoundDetection(entityId);
        LocalDate undoWithdrawalDate = command.localDateValueOfParameterNamed("reopenedDate");
        if (!client.isWithdrawn()) {
            String errorMessage = "only withdrawal clients may be reactivated.";
            throw new InvalidClientStateTransitionException("undoWithdrawal", "on.nonwithdrawal.account", "only withdrawal clients may be reactivated.", new Object[0]);
        }
        if (DateUtils.isAfter((LocalDate)client.getWithdrawalDate(), (LocalDate)undoWithdrawalDate)) {
            String errorMessage = "The client reactivation date cannot be before the client withdrawal date.";
            throw new InvalidClientStateTransitionException("reopened", "date.cannot.before.client.withdrawal.date", "The client reactivation date cannot be before the client withdrawal date.", new Object[]{undoWithdrawalDate, client.getWithdrawalDate()});
        }
        client.reOpened(currentUser, undoWithdrawalDate);
        this.clientRepository.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withClientId(entityId).withEntityId(entityId).withEntityExternalId(client.getExternalId()).build();
    }

    @Generated
    public ClientWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, ClientRepositoryWrapper clientRepository, ClientNonPersonRepositoryWrapper clientNonPersonRepository, OfficeRepositoryWrapper officeRepositoryWrapper, NoteRepository noteRepository, GroupRepository groupRepository, ClientDataValidator fromApiJsonDeserializer, AccountNumberGenerator accountNumberGenerator, StaffRepositoryWrapper staffRepository, CodeValueRepositoryWrapper codeValueRepository, LoanRepositoryWrapper loanRepositoryWrapper, SavingsAccountRepositoryWrapper savingsRepositoryWrapper, SavingsProductRepository savingsProductRepository, SavingsApplicationProcessWritePlatformService savingsApplicationProcessWritePlatformService, CommandProcessingService commandProcessingService, ConfigurationDomainService configurationDomainService, AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, FromJsonHelper fromApiJsonHelper, AddressWritePlatformService addressWritePlatformService, ClientFamilyMembersWritePlatformService clientFamilyMembersWritePlatformService, BusinessEventNotifierService businessEventNotifierService, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, ExternalIdFactory externalIdFactory) {
        this.context = context;
        this.clientRepository = clientRepository;
        this.clientNonPersonRepository = clientNonPersonRepository;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.noteRepository = noteRepository;
        this.groupRepository = groupRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.accountNumberGenerator = accountNumberGenerator;
        this.staffRepository = staffRepository;
        this.codeValueRepository = codeValueRepository;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.savingsRepositoryWrapper = savingsRepositoryWrapper;
        this.savingsProductRepository = savingsProductRepository;
        this.savingsApplicationProcessWritePlatformService = savingsApplicationProcessWritePlatformService;
        this.commandProcessingService = commandProcessingService;
        this.configurationDomainService = configurationDomainService;
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.addressWritePlatformService = addressWritePlatformService;
        this.clientFamilyMembersWritePlatformService = clientFamilyMembersWritePlatformService;
        this.businessEventNotifierService = businessEventNotifierService;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.externalIdFactory = externalIdFactory;
    }
}

