/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.data;

import java.util.Collection;
import org.apache.fineract.portfolio.collectionsheet.data.LoanDueData;
import org.apache.fineract.portfolio.collectionsheet.data.SavingsDueData;

public final class IndividualClientData {
    private final Long clientId;
    private final String clientName;
    private Collection<LoanDueData> loans;
    private Collection<SavingsDueData> savings;

    public static IndividualClientData instance(Long clientId, String clientName) {
        Collection loans = null;
        Collection savings = null;
        return new IndividualClientData(clientId, clientName, loans, savings);
    }

    public static IndividualClientData withSavings(IndividualClientData client, Collection<SavingsDueData> savings) {
        return new IndividualClientData(client.clientId, client.clientName, client.loans, savings);
    }

    public static IndividualClientData withLoans(IndividualClientData client, Collection<LoanDueData> loans) {
        return new IndividualClientData(client.clientId, client.clientName, loans, client.savings);
    }

    private IndividualClientData(Long clientId, String clientName, Collection<LoanDueData> loans, Collection<SavingsDueData> savings) {
        this.clientId = clientId;
        this.clientName = clientName;
        this.loans = loans;
        this.savings = savings;
    }

    public Long getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public Collection<LoanDueData> getLoans() {
        return this.loans;
    }

    public void setLoans(Collection<LoanDueData> loans) {
        this.loans = loans;
    }

    public void addLoans(LoanDueData loans) {
        if (this.loans != null) {
            this.loans.add(loans);
        }
    }

    public Collection<SavingsDueData> getSavings() {
        return this.savings;
    }

    public void setSavings(Collection<SavingsDueData> savings) {
        this.savings = savings;
    }

    public void addSavings(SavingsDueData savings) {
        if (this.savings != null) {
            this.savings.add(savings);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndividualClientData)) {
            return false;
        }
        IndividualClientData clientData = (IndividualClientData)obj;
        return clientData.clientId.compareTo(this.clientId) == 0;
    }

    public int hashCode() {
        return this.clientId.hashCode();
    }
}

