/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.device.service;

import java.util.Collection;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistrationData;
import org.apache.fineract.portfolio.self.device.exception.DeviceRegistrationNotFoundException;
import org.apache.fineract.portfolio.self.device.service.DeviceRegistrationReadPlatformService;
import org.apache.fineract.portfolio.self.device.service.DeviceRegistrationReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class DeviceRegistrationReadPlatformServiceImpl
implements DeviceRegistrationReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public DeviceRegistrationReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<DeviceRegistrationData> retrieveAllDeviceRegiistrations() {
        this.context.authenticatedUser();
        DeviceRegistrationDataMapper drm = new DeviceRegistrationDataMapper();
        String sql = "select " + drm.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)drm);
    }

    public DeviceRegistrationData retrieveDeviceRegiistration(Long id) {
        try {
            this.context.authenticatedUser();
            DeviceRegistrationDataMapper drm = new DeviceRegistrationDataMapper();
            String sql = "select " + drm.schema() + " where cdr.id = ? ";
            return (DeviceRegistrationData)this.jdbcTemplate.queryForObject(sql, (RowMapper)drm, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            throw new DeviceRegistrationNotFoundException(id, e);
        }
    }

    public DeviceRegistrationData retrieveDeviceRegiistrationByClientId(Long clientId) {
        try {
            this.context.authenticatedUser();
            DeviceRegistrationDataMapper drm = new DeviceRegistrationDataMapper();
            String sql = "select " + drm.schema() + " where c.id = ? ";
            return (DeviceRegistrationData)this.jdbcTemplate.queryForObject(sql, (RowMapper)drm, new Object[]{clientId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new DeviceRegistrationNotFoundException(clientId, "client", e);
        }
    }
}

