/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.tax.starter;

import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepositoryWrapper;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.tax.domain.TaxComponentRepository;
import org.apache.fineract.portfolio.tax.domain.TaxComponentRepositoryWrapper;
import org.apache.fineract.portfolio.tax.domain.TaxGroupRepository;
import org.apache.fineract.portfolio.tax.domain.TaxGroupRepositoryWrapper;
import org.apache.fineract.portfolio.tax.serialization.TaxValidator;
import org.apache.fineract.portfolio.tax.service.TaxAssembler;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformServiceImpl;
import org.apache.fineract.portfolio.tax.service.TaxWritePlatformService;
import org.apache.fineract.portfolio.tax.service.TaxWritePlatformServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class TaxConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TaxAssembler.class})
    public TaxAssembler taxAssembler(FromJsonHelper fromApiJsonHelper, GLAccountRepositoryWrapper glAccountRepositoryWrapper, TaxComponentRepositoryWrapper taxComponentRepositoryWrapper) {
        return new TaxAssembler(fromApiJsonHelper, glAccountRepositoryWrapper, taxComponentRepositoryWrapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={TaxReadPlatformService.class})
    public TaxReadPlatformService taxReadPlatformService(JdbcTemplate jdbcTemplate, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService) {
        return new TaxReadPlatformServiceImpl(jdbcTemplate, accountingDropdownReadPlatformService);
    }

    @Bean
    @ConditionalOnMissingBean(value={TaxWritePlatformService.class})
    public TaxWritePlatformService taxWritePlatformService(TaxValidator validator, TaxAssembler taxAssembler, TaxComponentRepository taxComponentRepository, TaxGroupRepository taxGroupRepository, TaxComponentRepositoryWrapper taxComponentRepositoryWrapper, TaxGroupRepositoryWrapper taxGroupRepositoryWrapper) {
        return new TaxWritePlatformServiceImpl(validator, taxAssembler, taxComponentRepository, taxComponentRepositoryWrapper, taxGroupRepository, taxGroupRepositoryWrapper);
    }
}

