/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GLAccountData;
import org.apache.fineract.client.models.TaxComponentHistoryData;

/**
 * TaxComponentData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class TaxComponentData {
  public static final String SERIALIZED_NAME_CREDIT_ACCOUNT = "creditAccount";
  @SerializedName(SERIALIZED_NAME_CREDIT_ACCOUNT)
  private GLAccountData creditAccount;

  public static final String SERIALIZED_NAME_CREDIT_ACCOUNT_TYPE = "creditAccountType";
  @SerializedName(SERIALIZED_NAME_CREDIT_ACCOUNT_TYPE)
  private EnumOptionData creditAccountType;

  public static final String SERIALIZED_NAME_DEBIT_ACCOUNT = "debitAccount";
  @SerializedName(SERIALIZED_NAME_DEBIT_ACCOUNT)
  private GLAccountData debitAccount;

  public static final String SERIALIZED_NAME_DEBIT_ACCOUNT_TYPE = "debitAccountType";
  @SerializedName(SERIALIZED_NAME_DEBIT_ACCOUNT_TYPE)
  private EnumOptionData debitAccountType;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_OPTIONS = "glAccountOptions";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_OPTIONS)
  private Map<String, List<GLAccountData>> glAccountOptions;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_TYPE_OPTIONS = "glAccountTypeOptions";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_TYPE_OPTIONS)
  private List<EnumOptionData> glAccountTypeOptions;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_PERCENTAGE = "percentage";
  @SerializedName(SERIALIZED_NAME_PERCENTAGE)
  private BigDecimal percentage;

  public static final String SERIALIZED_NAME_START_DATE = "startDate";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private LocalDate startDate;

  public static final String SERIALIZED_NAME_TAX_COMPONENT_HISTORIES = "taxComponentHistories";
  @SerializedName(SERIALIZED_NAME_TAX_COMPONENT_HISTORIES)
  private List<TaxComponentHistoryData> taxComponentHistories;

  public TaxComponentData() {
  }

  public TaxComponentData creditAccount(GLAccountData creditAccount) {
    
    this.creditAccount = creditAccount;
    return this;
  }

  /**
   * Get creditAccount
   * @return creditAccount
   */
  @javax.annotation.Nullable

  public GLAccountData getCreditAccount() {
    return creditAccount;
  }


  public void setCreditAccount(GLAccountData creditAccount) {
    this.creditAccount = creditAccount;
  }

  public TaxComponentData creditAccountType(EnumOptionData creditAccountType) {
    
    this.creditAccountType = creditAccountType;
    return this;
  }

  /**
   * Get creditAccountType
   * @return creditAccountType
   */
  @javax.annotation.Nullable

  public EnumOptionData getCreditAccountType() {
    return creditAccountType;
  }


  public void setCreditAccountType(EnumOptionData creditAccountType) {
    this.creditAccountType = creditAccountType;
  }

  public TaxComponentData debitAccount(GLAccountData debitAccount) {
    
    this.debitAccount = debitAccount;
    return this;
  }

  /**
   * Get debitAccount
   * @return debitAccount
   */
  @javax.annotation.Nullable

  public GLAccountData getDebitAccount() {
    return debitAccount;
  }


  public void setDebitAccount(GLAccountData debitAccount) {
    this.debitAccount = debitAccount;
  }

  public TaxComponentData debitAccountType(EnumOptionData debitAccountType) {
    
    this.debitAccountType = debitAccountType;
    return this;
  }

  /**
   * Get debitAccountType
   * @return debitAccountType
   */
  @javax.annotation.Nullable

  public EnumOptionData getDebitAccountType() {
    return debitAccountType;
  }


  public void setDebitAccountType(EnumOptionData debitAccountType) {
    this.debitAccountType = debitAccountType;
  }

  public TaxComponentData glAccountOptions(Map<String, List<GLAccountData>> glAccountOptions) {
    
    this.glAccountOptions = glAccountOptions;
    return this;
  }

  public TaxComponentData putGlAccountOptionsItem(String key, List<GLAccountData> glAccountOptionsItem) {
    if (this.glAccountOptions == null) {
      this.glAccountOptions = new HashMap<>();
    }
    this.glAccountOptions.put(key, glAccountOptionsItem);
    return this;
  }

  /**
   * Get glAccountOptions
   * @return glAccountOptions
   */
  @javax.annotation.Nullable

  public Map<String, List<GLAccountData>> getGlAccountOptions() {
    return glAccountOptions;
  }


  public void setGlAccountOptions(Map<String, List<GLAccountData>> glAccountOptions) {
    this.glAccountOptions = glAccountOptions;
  }

  public TaxComponentData glAccountTypeOptions(List<EnumOptionData> glAccountTypeOptions) {
    
    this.glAccountTypeOptions = glAccountTypeOptions;
    return this;
  }

  public TaxComponentData addGlAccountTypeOptionsItem(EnumOptionData glAccountTypeOptionsItem) {
    if (this.glAccountTypeOptions == null) {
      this.glAccountTypeOptions = new ArrayList<>();
    }
    this.glAccountTypeOptions.add(glAccountTypeOptionsItem);
    return this;
  }

  /**
   * Get glAccountTypeOptions
   * @return glAccountTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getGlAccountTypeOptions() {
    return glAccountTypeOptions;
  }


  public void setGlAccountTypeOptions(List<EnumOptionData> glAccountTypeOptions) {
    this.glAccountTypeOptions = glAccountTypeOptions;
  }

  public TaxComponentData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public TaxComponentData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public TaxComponentData percentage(BigDecimal percentage) {
    
    this.percentage = percentage;
    return this;
  }

  /**
   * Get percentage
   * @return percentage
   */
  @javax.annotation.Nullable

  public BigDecimal getPercentage() {
    return percentage;
  }


  public void setPercentage(BigDecimal percentage) {
    this.percentage = percentage;
  }

  public TaxComponentData startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable

  public LocalDate getStartDate() {
    return startDate;
  }


  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  public TaxComponentData taxComponentHistories(List<TaxComponentHistoryData> taxComponentHistories) {
    
    this.taxComponentHistories = taxComponentHistories;
    return this;
  }

  public TaxComponentData addTaxComponentHistoriesItem(TaxComponentHistoryData taxComponentHistoriesItem) {
    if (this.taxComponentHistories == null) {
      this.taxComponentHistories = new ArrayList<>();
    }
    this.taxComponentHistories.add(taxComponentHistoriesItem);
    return this;
  }

  /**
   * Get taxComponentHistories
   * @return taxComponentHistories
   */
  @javax.annotation.Nullable

  public List<TaxComponentHistoryData> getTaxComponentHistories() {
    return taxComponentHistories;
  }


  public void setTaxComponentHistories(List<TaxComponentHistoryData> taxComponentHistories) {
    this.taxComponentHistories = taxComponentHistories;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaxComponentData taxComponentData = (TaxComponentData) o;
    return Objects.equals(this.creditAccount, taxComponentData.creditAccount) &&
        Objects.equals(this.creditAccountType, taxComponentData.creditAccountType) &&
        Objects.equals(this.debitAccount, taxComponentData.debitAccount) &&
        Objects.equals(this.debitAccountType, taxComponentData.debitAccountType) &&
        Objects.equals(this.glAccountOptions, taxComponentData.glAccountOptions) &&
        Objects.equals(this.glAccountTypeOptions, taxComponentData.glAccountTypeOptions) &&
        Objects.equals(this.id, taxComponentData.id) &&
        Objects.equals(this.name, taxComponentData.name) &&
        Objects.equals(this.percentage, taxComponentData.percentage) &&
        Objects.equals(this.startDate, taxComponentData.startDate) &&
        Objects.equals(this.taxComponentHistories, taxComponentData.taxComponentHistories);
  }

  @Override
  public int hashCode() {
    return Objects.hash(creditAccount, creditAccountType, debitAccount, debitAccountType, glAccountOptions, glAccountTypeOptions, id, name, percentage, startDate, taxComponentHistories);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaxComponentData {\n");
    sb.append("    creditAccount: ").append(toIndentedString(creditAccount)).append("\n");
    sb.append("    creditAccountType: ").append(toIndentedString(creditAccountType)).append("\n");
    sb.append("    debitAccount: ").append(toIndentedString(debitAccount)).append("\n");
    sb.append("    debitAccountType: ").append(toIndentedString(debitAccountType)).append("\n");
    sb.append("    glAccountOptions: ").append(toIndentedString(glAccountOptions)).append("\n");
    sb.append("    glAccountTypeOptions: ").append(toIndentedString(glAccountTypeOptions)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    percentage: ").append(toIndentedString(percentage)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    taxComponentHistories: ").append(toIndentedString(taxComponentHistories)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

