/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.api.functions.StateBootstrapFunction;
import org.apache.flink.state.api.output.SnapshotUtils;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
public class StateBootstrapOperator<IN>
extends AbstractUdfStreamOperator<TaggedOperatorSubtaskState, StateBootstrapFunction<IN>>
implements OneInputStreamOperator<IN, TaggedOperatorSubtaskState>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final long checkpointId;
    private final long timestamp;
    private final Path savepointPath;
    private transient ContextImpl context;

    public StateBootstrapOperator(long checkpointId, long timestamp, Path savepointPath, StateBootstrapFunction<IN> function) {
        super(function);
        this.checkpointId = checkpointId;
        this.timestamp = timestamp;
        this.savepointPath = savepointPath;
    }

    public void open() throws Exception {
        super.open();
        this.context = new ContextImpl(this.getProcessingTimeService());
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        ((StateBootstrapFunction)this.userFunction).processElement(element.getValue(), this.context);
    }

    public void endInput() throws Exception {
        TaggedOperatorSubtaskState state = SnapshotUtils.snapshot(this.checkpointId, this, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.timestamp, this.getContainingTask().getConfiguration().isExactlyOnceCheckpointMode(), this.getContainingTask().getConfiguration().isUnalignedCheckpointsEnabled(), this.getContainingTask().getConfiguration().getConfiguration(), this.savepointPath);
        this.output.collect((Object)new StreamRecord((Object)state));
    }

    private class ContextImpl
    implements StateBootstrapFunction.Context {
        private final ProcessingTimeService processingTimeService;

        ContextImpl(ProcessingTimeService processingTimeService) {
            this.processingTimeService = processingTimeService;
        }

        @Override
        public long currentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }
    }
}

