/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.writer;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.flink.core.fs.BackPressuringExecutor;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.osshadoop.OSSAccessor;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverable;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverableFsDataOutputStream;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverableMultipartUpload;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverableSerializer;
import org.apache.flink.util.function.FunctionWithException;

public class OSSRecoverableWriter
implements RecoverableWriter {
    private OSSAccessor ossAccessor;
    private long ossUploadPartSize;
    private int streamConcurrentUploads;
    private Executor executor;
    private final FunctionWithException<File, RefCountedFileWithStream, IOException> cachedFileCreator;

    public OSSRecoverableWriter(OSSAccessor ossAccessor, long ossUploadPartSize, int streamConcurrentUploads, Executor executor, FunctionWithException<File, RefCountedFileWithStream, IOException> cachedFileCreator) {
        this.ossAccessor = ossAccessor;
        this.ossUploadPartSize = ossUploadPartSize;
        this.streamConcurrentUploads = streamConcurrentUploads;
        this.executor = executor;
        this.cachedFileCreator = cachedFileCreator;
    }

    public RecoverableFsDataOutputStream open(Path path) throws IOException {
        return new OSSRecoverableFsDataOutputStream(this.ossUploadPartSize, this.cachedFileCreator, new OSSRecoverableMultipartUpload(this.ossAccessor.pathToObject(path), this.getExecutor(), this.ossAccessor, Optional.empty(), null, null, 0L), 0L);
    }

    public OSSRecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable resumable) throws IOException {
        OSSRecoverable recoverable = (OSSRecoverable)resumable;
        OSSRecoverableMultipartUpload upload = new OSSRecoverableMultipartUpload(recoverable.getObjectName(), this.getExecutor(), this.ossAccessor, this.recoverInProgressPart(recoverable), recoverable.getUploadId(), recoverable.getPartETags(), recoverable.getNumBytesInParts());
        return new OSSRecoverableFsDataOutputStream(this.ossUploadPartSize, this.cachedFileCreator, upload, recoverable.getNumBytesInParts());
    }

    private Optional<File> recoverInProgressPart(OSSRecoverable recoverable) throws IOException {
        String objectKey = recoverable.getLastPartObject();
        if (objectKey == null) {
            return Optional.empty();
        }
        RefCountedFileWithStream refCountedFile = (RefCountedFileWithStream)this.cachedFileCreator.apply(null);
        File file = refCountedFile.getFile();
        this.ossAccessor.getObject(objectKey, file.getAbsolutePath(), recoverable.getLastPartObjectLength());
        return Optional.of(file);
    }

    public boolean requiresCleanupOfRecoverableState() {
        return true;
    }

    public boolean cleanupRecoverableState(RecoverableWriter.ResumeRecoverable resumable) throws IOException {
        OSSRecoverable ossRecoverable = (OSSRecoverable)resumable;
        String smallPartObjectToDelete = ossRecoverable.getLastPartObject();
        return smallPartObjectToDelete != null && this.ossAccessor.deleteObject(smallPartObjectToDelete);
    }

    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable resumable) throws IOException {
        OSSRecoverableFsDataOutputStream recovered = this.recover((OSSRecoverable)resumable);
        return recovered.closeForCommit();
    }

    public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitRecoverableSerializer() {
        return OSSRecoverableSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeRecoverableSerializer() {
        return OSSRecoverableSerializer.INSTANCE;
    }

    public boolean supportsResume() {
        return true;
    }

    private Executor getExecutor() {
        if (this.streamConcurrentUploads <= 0) {
            return this.executor;
        }
        return new BackPressuringExecutor(this.executor, this.streamConcurrentUploads);
    }
}

