/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.batch.AggWithoutKeysCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.generator.OneInputOpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.spec.HashAggFusionCodegenSpec;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecHashAggregate
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final int[] grouping;
    private final int[] auxGrouping;
    private final AggregateCall[] aggCalls;
    private final RowType aggInputRowType;
    private final boolean isMerge;
    private final boolean isFinal;
    private final boolean supportAdaptiveLocalHashAgg;

    public BatchExecHashAggregate(ReadableConfig tableConfig, int[] grouping, int[] auxGrouping, AggregateCall[] aggCalls, RowType aggInputRowType, boolean isMerge, boolean isFinal, boolean supportAdaptiveLocalHashAgg, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecHashAggregate.class), ExecNodeContext.newPersistedConfig(BatchExecHashAggregate.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.aggInputRowType = aggInputRowType;
        this.isMerge = isMerge;
        this.isFinal = isFinal;
        this.supportAdaptiveLocalHashAgg = supportAdaptiveLocalHashAgg;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        GeneratedOperator<OneInputStreamOperator<RowData, RowData>> generatedOperator;
        long managedMemory;
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        RowType outputRowType = (RowType)this.getOutputType();
        CodeGeneratorContext ctx = new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader());
        AggregateInfoList aggInfos = AggregateUtil.transformToBatchAggregateInfoList(planner.getTypeFactory(), this.aggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), null, null);
        if (this.grouping.length == 0) {
            managedMemory = 0L;
            generatedOperator = AggWithoutKeysCodeGenerator.genWithoutKeys(ctx, planner.createRelBuilder(), aggInfos, inputRowType, outputRowType, this.isMerge, this.isFinal, "NoGrouping");
        } else {
            managedMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY)).getBytes();
            generatedOperator = HashAggCodeGenerator.genWithKeys(ctx, planner.createRelBuilder(), aggInfos, inputRowType, outputRowType, this.grouping, this.auxGrouping, this.isMerge, this.isFinal, this.supportAdaptiveLocalHashAgg, (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLES), (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED), (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes());
        }
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationName(config), this.createTransformationDescription(config), new CodeGenOperatorFactory(generatedOperator), InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism(), managedMemory, false);
    }

    @Override
    public boolean supportFusionCodegen() {
        return true;
    }

    @Override
    protected OpFusionCodegenSpecGenerator translateToFusionCodegenSpecInternal(PlannerBase planner, ExecNodeConfig config, CodeGeneratorContext parentCtx) {
        OpFusionCodegenSpecGenerator input = this.getInputEdges().get(0).translateToFusionCodegenSpec(planner, parentCtx);
        AggregateInfoList aggInfos = AggregateUtil.transformToBatchAggregateInfoList(planner.getTypeFactory(), this.aggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), null, null);
        long managedMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY)).getBytes();
        if (this.grouping.length == 0) {
            managedMemory = 0L;
        }
        OneInputOpFusionCodegenSpecGenerator hashAggSpecGenerator = new OneInputOpFusionCodegenSpecGenerator(input, managedMemory, (RowType)this.getOutputType(), new HashAggFusionCodegenSpec(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader(), parentCtx), planner.createRelBuilder(), aggInfos, this.grouping, this.auxGrouping, this.isFinal, this.isMerge, this.supportAdaptiveLocalHashAgg, (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_SORT_MAX_NUM_FILE_HANDLES), (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED), (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes()));
        input.addOutput(1, hashAggSpecGenerator);
        return hashAggSpecGenerator;
    }
}

