/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.conversion.DayTimeIntervalDurationConverter;
import org.apache.flink.table.data.conversion.YearMonthIntervalPeriodConverter;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.NestedFieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.plan.utils.NestedColumn;
import org.apache.flink.table.planner.plan.utils.NestedProjectionUtil$;
import org.apache.flink.table.planner.plan.utils.NestedSchema;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter$;
import org.apache.flink.table.planner.utils.TimestampStringUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001E\u0011ADU3y\u001d>$W\rV8FqB\u0014Xm]:j_:\u001cuN\u001c<feR,'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IQ\u0002CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007m\u0001#%D\u0001\u001d\u0015\tib$A\u0002sKbT!a\b\u0007\u0002\u000f\r\fGnY5uK&\u0011\u0011\u0005\b\u0002\u000b%\u0016Dh+[:ji>\u0014\bcA\u0012'Q5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004PaRLwN\u001c\t\u0003S1j\u0011A\u000b\u0006\u0003W!\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011QF\u000b\u0002\u0013%\u0016\u001cx\u000e\u001c<fI\u0016C\bO]3tg&|g\u000e\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003)\u0011X\r\u001f\"vS2$WM\u001d\t\u00037EJ!A\r\u000f\u0003\u0015I+\u0007PQ;jY\u0012,'\u000f\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0003)Ig\u000e];u\u001d\u0006lWm\u001d\t\u0004GYB\u0014BA\u001c%\u0005\u0015\t%O]1z!\tI\u0004I\u0004\u0002;}A\u00111\bJ\u0007\u0002y)\u0011Q\bE\u0001\u0007yI|w\u000e\u001e \n\u0005}\"\u0013A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u0013\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000bqBZ;oGRLwN\\\"bi\u0006dwn\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\"\tqaY1uC2|w-\u0003\u0002K\u000f\nya)\u001e8di&|gnQ1uC2|w\r\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"A\u0012(\n\u0005=;%AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\t#\u0002\u0011\t\u0011)A\u0005%\u0006Y!/\u001a7ECR\fG+\u001f9f!\r\u0019ce\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA\u0001^=qK*\u0011\u0001LH\u0001\u0004e\u0016d\u0017B\u0001.V\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u000bq\u0003A\u0011A/\u0002\rqJg.\u001b;?)\u0019q\u0006-\u00192dIB\u0011q\fA\u0007\u0002\u0005!)qf\u0017a\u0001a!)Ag\u0017a\u0001k!)Ai\u0017a\u0001\u000b\")Aj\u0017a\u0001\u001b\"9\u0011k\u0017I\u0001\u0002\u0004\u0011\u0006\"\u0002/\u0001\t\u00031G#\u00020hQ&T\u0007\"B\u0018f\u0001\u0004\u0001\u0004\"\u0002\u001bf\u0001\u0004)\u0004\"\u0002#f\u0001\u0004)\u0005\"\u0002'f\u0001\u0004i\u0005\"\u00027\u0001\t\u0003j\u0017!\u0004<jg&$\u0018J\u001c9viJ+g\r\u0006\u0002#]\")qn\u001ba\u0001a\u0006A\u0011N\u001c9viJ+g\r\u0005\u0002\u001cc&\u0011!\u000f\b\u0002\f%\u0016D\u0018J\u001c9viJ+g\rC\u0003u\u0001\u0011\u0005S/\u0001\nwSNLG\u000fV1cY\u0016Le\u000e];u%\u00164GC\u0001\u0012w\u0011\u001598\u000f1\u0001y\u0003A\u0011X\r\u001f+bE2,\u0017J\u001c9viJ+g\r\u0005\u0002\u001cs&\u0011!\u0010\b\u0002\u0011%\u0016DH+\u00192mK&s\u0007/\u001e;SK\u001aDQ\u0001 \u0001\u0005Bu\fQB^5tSRdunY1m%\u00164GC\u0001\u0012\u007f\u0011\u0019y8\u00101\u0001\u0002\u0002\u0005AAn\\2bYJ+g\rE\u0002\u001c\u0003\u0007I1!!\u0002\u001d\u0005-\u0011V\r\u001f'pG\u0006d'+\u001a4\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\u0005aa/[:ji2KG/\u001a:bYR\u0019!%!\u0004\t\u0011\u0005=\u0011q\u0001a\u0001\u0003#\tq\u0001\\5uKJ\fG\u000eE\u0002\u001c\u0003'I1!!\u0006\u001d\u0005)\u0011V\r\u001f'ji\u0016\u0014\u0018\r\u001c\u0005\b\u00033\u0001A\u0011IA\u000e\u0003%1\u0018n]5u\u0007\u0006dG\u000eF\u0002#\u0003;A\u0001\"a\b\u0002\u0018\u0001\u0007\u0011\u0011E\u0001\u000b_JL'+\u001a=DC2d\u0007cA\u000e\u0002$%\u0019\u0011Q\u0005\u000f\u0003\u000fI+\u0007pQ1mY\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012\u0001\u0005<jg&$h)[3mI\u0006\u001b7-Z:t)\r\u0011\u0013Q\u0006\u0005\t\u0003_\t9\u00031\u0001\u00022\u0005Ya-[3mI\u0006\u001b7-Z:t!\rY\u00121G\u0005\u0004\u0003ka\"A\u0004*fq\u001aKW\r\u001c3BG\u000e,7o\u001d\u0005\b\u0003s\u0001A\u0011IA\u001e\u0003M1\u0018n]5u\u0007>\u0014(/\u001a7WCJL\u0017M\u00197f)\r\u0011\u0013Q\b\u0005\t\u0003\u007f\t9\u00041\u0001\u0002B\u0005q1m\u001c:sK24\u0016M]5bE2,\u0007cA\u000e\u0002D%\u0019\u0011Q\t\u000f\u0003#I+\u0007pQ8se\u0016dg+\u0019:jC\ndW\rC\u0004\u0002J\u0001!\t%a\u0013\u0002\u001bYL7/\u001b;SC:<WMU3g)\r\u0011\u0013Q\n\u0005\t\u0003\u001f\n9\u00051\u0001\u0002R\u0005A!/\u00198hKJ+g\rE\u0002\u001c\u0003'J1!!\u0016\u001d\u0005-\u0011V\r\u001f*b]\u001e,'+\u001a4\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\u0005ia/[:jiN+(-U;fef$2AIA/\u0011!\ty&a\u0016A\u0002\u0005\u0005\u0014\u0001C:vEF+XM]=\u0011\u0007m\t\u0019'C\u0002\u0002fq\u00111BU3y'V\u0014\u0017+^3ss\"9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0014!\u0005<jg&$H)\u001f8b[&\u001c\u0007+\u0019:b[R\u0019!%!\u001c\t\u0011\u0005=\u0014q\ra\u0001\u0003c\nA\u0002Z=oC6L7\rU1sC6\u00042aGA:\u0013\r\t)\b\b\u0002\u0010%\u0016DH)\u001f8b[&\u001c\u0007+\u0019:b[\"9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0014!\u0003<jg&$xJ^3s)\r\u0011\u0013Q\u0010\u0005\t\u0003\u007f\n9\b1\u0001\u0002\u0002\u0006!qN^3s!\rY\u00121Q\u0005\u0004\u0003\u000bc\"a\u0002*fq>3XM\u001d\u0005\b\u0003\u0013\u0003A\u0011IAF\u0003Q1\u0018n]5u!\u0006$H/\u001a:o\r&,G\u000e\u001a*fMR\u0019!%!$\t\u0011\u0005=\u0015q\u0011a\u0001\u0003#\u000b\u0001BZ5fY\u0012\u0014VM\u001a\t\u00047\u0005M\u0015bAAK9\t\u0011\"+\u001a=QCR$XM\u001d8GS\u0016dGMU3g\u0011\u001d\tI\n\u0001C\u0005\u00037\u000ba\u0002\\8pWV\u0004h)\u001e8di&|g\u000eF\u0004#\u0003;\u000b9+!0\t\u0011\u0005}\u0015q\u0013a\u0001\u0003C\u000b!\"\u001b3f]RLg-[3s!\r1\u00151U\u0005\u0004\u0003K;%\u0001F+oe\u0016\u001cx\u000e\u001c<fI&#WM\u001c;jM&,'\u000f\u0003\u0005\u0002*\u0006]\u0005\u0019AAV\u0003!y\u0007/\u001a:b]\u0012\u001c\b#BAW\u0003oCc\u0002BAX\u0003gs1aOAY\u0013\u0005)\u0013bAA[I\u00059\u0001/Y2lC\u001e,\u0017\u0002BA]\u0003w\u00131aU3r\u0015\r\t)\f\n\u0005\t\u0003\u007f\u000b9\n1\u0001\u0002B\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bT1!a2\t\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY-!2\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a4\u0001\t\u0013\t\t.A\u0004sKBd\u0017mY3\u0015\u0007a\n\u0019\u000eC\u0004\u0002V\u00065\u0007\u0019\u0001\u001d\u0002\u0007M$(oB\u0005\u0002Z\n\t\t\u0011#\u0001\u0002\\\u0006a\"+\u001a=O_\u0012,Gk\\#yaJ,7o]5p]\u000e{gN^3si\u0016\u0014\bcA0\u0002^\u001aA\u0011AAA\u0001\u0012\u0003\tyn\u0005\u0003\u0002^\u0006\u0005\bcA\u0012\u0002d&\u0019\u0011Q\u001d\u0013\u0003\r\u0005s\u0017PU3g\u0011\u001da\u0016Q\u001cC\u0001\u0003S$\"!a7\t\u0015\u00055\u0018Q\\I\u0001\n\u0003\ty/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003cT3AUAzW\t\t)\u0010\u0005\u0003\u0002x\n\u0005QBAA}\u0015\u0011\tY0!@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0000I\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\u0011\u0011 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class RexNodeToExpressionConverter
implements RexVisitor<Option<ResolvedExpression>> {
    private final RexBuilder rexBuilder;
    private final String[] inputNames;
    private final FunctionCatalog functionCatalog;
    private final Option<RelDataType> relDataType;

    public static Option<RelDataType> $lessinit$greater$default$5() {
        return RexNodeToExpressionConverter$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public void visitList(Iterable<? extends RexNode> x$1, List<Option<ResolvedExpression>> x$2) {
        RexVisitor.super.visitList(x$1, x$2);
    }

    @Override
    public List<Option<ResolvedExpression>> visitList(Iterable<? extends RexNode> x$1) {
        return RexVisitor.super.visitList(x$1);
    }

    @Override
    public void visitEach(Iterable<? extends RexNode> x$1) {
        RexVisitor.super.visitEach(x$1);
    }

    @Override
    public Option<ResolvedExpression> visitInputRef(RexInputRef inputRef) {
        Preconditions.checkArgument((inputRef.getIndex() < this.inputNames.length ? 1 : 0) != 0);
        return new Some((Object)new FieldReferenceExpression(this.inputNames[inputRef.getIndex()], LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(inputRef.getType())), 0, inputRef.getIndex()));
    }

    @Override
    public Option<ResolvedExpression> visitTableInputRef(RexTableInputRef rexTableInputRef) {
        return this.visitInputRef(rexTableInputRef);
    }

    @Override
    public Option<ResolvedExpression> visitLocalRef(RexLocalRef localRef) {
        throw new TableException("Bug: RexLocalRef should have been expanded");
    }

    @Override
    public Option<ResolvedExpression> visitLiteral(RexLiteral literal) {
        Object object;
        Comparable comparable = literal.getValue();
        if (comparable instanceof SqlTrimFunction.Flag) {
            return None$.MODULE$;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        LogicalType literalType = FlinkTypeFactory$.MODULE$.toLogicalType(literal.getType());
        LogicalTypeRoot logicalTypeRoot = literalType.getTypeRoot();
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = DataFormatConverters.LocalDateConverter.INSTANCE.toExternal((Object)v);
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = DataFormatConverters.LocalTimeConverter.INSTANCE.toExternal((Object)v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            object = TimestampStringUtils.toLocalDateTime(v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            object = TimestampStringUtils.toLocalDateTime(v).atZone(ZoneId.of(ZoneOffset.UTC.getId())).toInstant();
        } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            Long v = literal.getValueAs(Long.class);
            object = DayTimeIntervalDurationConverter.INSTANCE.toExternal(v);
        } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = YearMonthIntervalPeriodConverter.create((YearMonthIntervalType)((YearMonthIntervalType)literalType)).toExternal(v);
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Byte.class);
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Short.class);
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Integer.class);
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Long.class);
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Float.class);
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Double.class);
        } else {
            boolean bl = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
            if (bl) {
                object = literal.getValueAs(String.class);
            } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                object = literal.getValueAs(Boolean.class);
            } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                object = literal.getValueAs(BigDecimal.class);
            } else {
                boolean bl2 = LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot);
                object = bl2 ? (Object)literal.getValueAs(byte[].class) : literal.getValue();
            }
        }
        Object literalValue = object;
        DataType dataType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)literalType);
        return literalValue == null ? new Some((Object)ApiExpressionUtils.valueLiteral(null, (DataType)((DataType)dataType.nullable()))) : new Some((Object)ApiExpressionUtils.valueLiteral((Object)literalValue, (DataType)((DataType)dataType.notNull())));
    }

    @Override
    public Option<ResolvedExpression> visitCall(RexCall oriRexCall) {
        None$ none$;
        RexCall rexCall = (RexCall)FlinkRexUtil$.MODULE$.expandSearch(this.rexBuilder, oriRexCall);
        Buffer operands = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)operand -> (ResolvedExpression)operand.accept(this).orNull(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom());
        DataType outputType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(rexCall.getType()));
        if (operands.contains(null)) {
            none$ = None$.MODULE$;
        } else {
            Option<ResolvedExpression> option;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.OR;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
                option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.OR, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{l, r}))), (DataType)outputType)));
            } else {
                SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.AND;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.AND, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{l, r}))), (DataType)outputType)));
                } else {
                    SqlFunction sqlFunction = SqlStdOperatorTable.CAST;
                    SqlOperator sqlOperator4 = sqlOperator;
                    if (!(sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator4) : sqlOperator4 != null)) {
                        option = Option$.MODULE$.apply((Object)CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.CAST, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{(ResolvedExpression)operands.head(), ApiExpressionUtils.typeLiteral((DataType)outputType)}))), (DataType)outputType));
                    } else {
                        SqlFunction sqlFunction2 = FlinkSqlOperatorTable.TRY_CAST;
                        SqlOperator sqlOperator5 = sqlOperator;
                        if (!(sqlFunction2 != null ? !((Object)sqlFunction2).equals(sqlOperator5) : sqlOperator5 != null)) {
                            option = Option$.MODULE$.apply((Object)CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.TRY_CAST, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{(ResolvedExpression)operands.head(), ApiExpressionUtils.typeLiteral((DataType)outputType)}))), (DataType)outputType));
                        } else {
                            boolean bl = sqlOperator instanceof SqlFunction ? true : sqlOperator instanceof SqlPostfixOperator;
                            if (bl) {
                                ArrayList<String> names = new ArrayList<String>(rexCall.getOperator().getNameAsId().names);
                                names.set(names.size() - 1, this.replace(names.get(names.size() - 1)));
                                UnresolvedIdentifier id = UnresolvedIdentifier.of((String[])((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(names).asScala()).toArray(ClassTag$.MODULE$.apply(String.class))));
                                option = this.lookupFunction(id, (Seq<ResolvedExpression>)operands, outputType);
                            } else {
                                option = this.lookupFunction(UnresolvedIdentifier.of((String[])new String[]{this.replace(String.valueOf((Object)sqlOperator.getKind()))}), (Seq<ResolvedExpression>)operands, outputType);
                            }
                        }
                    }
                }
            }
            none$ = option;
        }
        return none$;
    }

    @Override
    public Option<ResolvedExpression> visitFieldAccess(RexFieldAccess fieldAccess) {
        ArrayBuffer fieldNames;
        String topLevelColumnName;
        int[][] fieldIndices;
        RexNode rexNode = fieldAccess.getReferenceExpr();
        if (rexNode instanceof RexCall) {
            return None$.MODULE$;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Option<RelDataType> option = this.relDataType;
        if (option instanceof Some) {
            Some some = (Some)option;
            RelDataType dataType = (RelDataType)some.value();
            NestedSchema schema = NestedProjectionUtil$.MODULE$.build(Collections.singletonList(fieldAccess), dataType);
            fieldIndices = NestedProjectionUtil$.MODULE$.convertToIndexArray(schema);
            Tuple2 tuple2 = (Tuple2)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(schema.columns()).head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topLevelColumnName2 = (String)tuple2._1();
            NestedColumn nestedColumn = (NestedColumn)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topLevelColumnName2, (Object)nestedColumn);
            Tuple2 tuple23 = tuple22;
            topLevelColumnName = (String)tuple23._1();
            NestedColumn nestedColumn2 = (NestedColumn)tuple23._2();
            fieldNames = new ArrayBuffer();
            while (!nestedColumn2.isLeaf()) {
                JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)fieldNames).add(topLevelColumnName);
                topLevelColumnName = (String)((Tuple2)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(nestedColumn2.children()).head())._1();
                nestedColumn2 = (NestedColumn)((Tuple2)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(nestedColumn2.children()).head())._2();
            }
        } else {
            throw new MatchError(option);
        }
        JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)fieldNames).add(topLevelColumnName);
        Some some = new Some((Object)new NestedFieldReferenceExpression((String[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class)), fieldIndices[0], TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(fieldAccess.getType()))));
        return some;
    }

    @Override
    public Option<ResolvedExpression> visitCorrelVariable(RexCorrelVariable correlVariable) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitRangeRef(RexRangeRef rangeRef) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitSubQuery(RexSubQuery subQuery) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitDynamicParam(RexDynamicParam dynamicParam) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitOver(RexOver over) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return None$.MODULE$;
    }

    private Option<ResolvedExpression> lookupFunction(UnresolvedIdentifier identifier, Seq<ResolvedExpression> operands, DataType outputType) {
        None$ none$;
        Success success;
        Optional f;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.functionCatalog.lookupFunction(identifier));
        if (try_ instanceof Success && (f = (Optional)(success = (Success)try_).value()) != null) {
            None$ none$2;
            Optional optional = f;
            if (optional.isPresent()) {
                FunctionIdentifier functionIdentifier;
                ContextResolvedFunction resolvedFunction = (ContextResolvedFunction)optional.get();
                FunctionDefinition functionDefinition = resolvedFunction.getDefinition();
                if (functionDefinition instanceof BuiltInFunctionDefinition) {
                    BuiltInFunctionDefinition builtInFunctionDefinition = (BuiltInFunctionDefinition)functionDefinition;
                    functionIdentifier = FunctionIdentifier.of((String)builtInFunctionDefinition.getName());
                } else {
                    functionIdentifier = resolvedFunction.getIdentifier().orElse(null);
                }
                FunctionIdentifier identifier2 = functionIdentifier;
                none$2 = new Some((Object)new CallExpression(resolvedFunction.isTemporary(), identifier2, resolvedFunction.getDefinition(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(operands), outputType));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if (try_ instanceof Failure) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private String replace(String str) {
        return str.replaceAll("\\s|_", "");
    }

    public RexNodeToExpressionConverter(RexBuilder rexBuilder, String[] inputNames, FunctionCatalog functionCatalog, CatalogManager catalogManager, Option<RelDataType> relDataType) {
        this.rexBuilder = rexBuilder;
        this.inputNames = inputNames;
        this.functionCatalog = functionCatalog;
        this.relDataType = relDataType;
    }

    public RexNodeToExpressionConverter(RexBuilder rexBuilder, String[] inputNames, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this(rexBuilder, inputNames, functionCatalog, catalogManager, (Option<RelDataType>)None$.MODULE$);
    }
}

