/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class JsonFormatOptions {
    public static final ConfigOption<Boolean> FAIL_ON_MISSING_FIELD = ConfigOptions.key((String)"fail-on-missing-field").booleanType().defaultValue((Object)false).withDescription("Optional flag to specify whether to fail if a field is missing or not, false by default.");
    public static final ConfigOption<Boolean> IGNORE_PARSE_ERRORS = ConfigOptions.key((String)"ignore-parse-errors").booleanType().defaultValue((Object)false).withDescription("Optional flag to skip fields and rows with parse errors instead of failing;\nfields are set to null in case of errors, false by default.");
    public static final ConfigOption<String> MAP_NULL_KEY_MODE = ConfigOptions.key((String)"map-null-key.mode").stringType().defaultValue((Object)"FAIL").withDescription("Optional flag to control the handling mode when serializing null key for map data, FAIL by default. Option DROP will drop null key entries for map data. Option LITERAL will use 'map-null-key.literal' as key literal.");
    public static final ConfigOption<String> MAP_NULL_KEY_LITERAL = ConfigOptions.key((String)"map-null-key.literal").stringType().defaultValue((Object)"null").withDescription("Optional flag to specify string literal for null keys when 'map-null-key.mode' is LITERAL, \"null\" by default.");
    public static final ConfigOption<String> TIMESTAMP_FORMAT = ConfigOptions.key((String)"timestamp-format.standard").stringType().defaultValue((Object)"SQL").withDescription("Optional flag to specify timestamp format, SQL by default. Option ISO-8601 will parse input timestamp in \"yyyy-MM-ddTHH:mm:ss.s{precision}\" format and output timestamp in the same format. Option SQL will parse input timestamp in \"yyyy-MM-dd HH:mm:ss.s{precision}\" format and output timestamp in the same format.");
    public static final ConfigOption<Boolean> ENCODE_DECIMAL_AS_PLAIN_NUMBER = ConfigOptions.key((String)"encode.decimal-as-plain-number").booleanType().defaultValue((Object)false).withDescription("Optional flag to specify whether to encode all decimals as plain numbers instead of possible scientific notations, false by default.");
    public static final ConfigOption<Boolean> ENCODE_IGNORE_NULL_FIELDS = ConfigOptions.key((String)"encode.ignore-null-fields").booleanType().defaultValue((Object)false).withDescription("Optional flag to specify whether to ignore null fields when encoding, false by default.");
    public static final ConfigOption<Boolean> DECODE_JSON_PARSER_ENABLED = ConfigOptions.key((String)"decode.json-parser.enabled").booleanType().defaultValue((Object)true).withDescription("Optional flag to specify whether to use the Jackson JsonParser to decode json with better performance, true by default.");

    private JsonFormatOptions() {
    }

    public static enum MapNullKeyMode {
        FAIL,
        DROP,
        LITERAL;

    }
}

