/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.resource.ClientResourceManager;
import org.apache.flink.table.client.util.ClientClassloaderUtil;
import org.apache.flink.table.client.util.ClientWrapperClassLoader;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.operation.OperationExecutor;
import org.apache.flink.table.gateway.service.operation.OperationManager;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.gateway.service.session.Session;
import org.apache.flink.table.gateway.service.session.SessionManager;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.Preconditions;

public class SingleSessionManager
implements SessionManager {
    private final DefaultContext defaultContext;
    private final ExecutorService operationExecutorService;
    private Session session;

    public SingleSessionManager(DefaultContext defaultContext) {
        this.defaultContext = defaultContext;
        this.operationExecutorService = Executors.newSingleThreadExecutor();
    }

    public void start() {
    }

    public void stop() {
        this.operationExecutorService.shutdown();
    }

    public Session getSession(SessionHandle sessionHandle) throws SqlGatewayException {
        Preconditions.checkArgument((this.session != null && sessionHandle.equals((Object)this.session.getSessionHandle()) ? 1 : 0) != 0, (Object)"The specified session doesn't exists");
        return this.session;
    }

    public Session openSession(SessionEnvironment environment) throws SqlGatewayException {
        if (this.session != null) {
            throw new SqlClientException(String.format("The %s can only maintain one session at the same time. Please close the current session before opening a new session.", SingleSessionManager.class.getName()));
        }
        SessionHandle sessionHandle = SessionHandle.create();
        this.session = new Session((SessionContext)EmbeddedSessionContext.create(this.defaultContext, sessionHandle, environment, this.operationExecutorService));
        this.session.open();
        return this.session;
    }

    public void closeSession(SessionHandle sessionHandle) throws SqlGatewayException {
        Preconditions.checkArgument((this.session != null && sessionHandle.equals((Object)this.session.getSessionHandle()) ? 1 : 0) != 0, (Object)"The specified session doesn't exist.");
        this.session.close();
        this.session = null;
    }

    private static class EmbeddedOperationExecutor
    extends OperationExecutor {
        public EmbeddedOperationExecutor(SessionContext context, Configuration executionConfig) {
            super(context, executionConfig);
        }

        protected ResultFetcher callRemoveJar(OperationHandle operationHandle, String jarPath) {
            URL jarURL = ((ClientResourceManager)this.sessionContext.getSessionState().resourceManager).unregisterJarResource(jarPath);
            if (jarURL != null) {
                ((ClientWrapperClassLoader)((Object)this.sessionContext.getSessionState().resourceManager.getUserClassLoader())).removeURL(jarURL);
            }
            return ResultFetcher.fromTableResult((OperationHandle)operationHandle, (TableResultInternal)TableResultInternal.TABLE_RESULT_OK, (boolean)false);
        }
    }

    private static class EmbeddedSessionContext
    extends SessionContext {
        private EmbeddedSessionContext(DefaultContext defaultContext, SessionHandle sessionId, EndpointVersion endpointVersion, Configuration sessionConf, URLClassLoader classLoader, SessionContext.SessionState sessionState, OperationManager operationManager) {
            super(defaultContext, sessionId, endpointVersion, sessionConf, classLoader, sessionState, operationManager);
        }

        public static EmbeddedSessionContext create(DefaultContext defaultContext, SessionHandle sessionId, SessionEnvironment environment, ExecutorService operationExecutorService) {
            Configuration configuration = EmbeddedSessionContext.initializeConfiguration((DefaultContext)defaultContext, (SessionEnvironment)environment, (SessionHandle)sessionId);
            ClientWrapperClassLoader userClassLoader = new ClientWrapperClassLoader(ClientClassloaderUtil.buildUserClassLoader(defaultContext.getDependencies(), SessionContext.class.getClassLoader(), new Configuration(configuration)), configuration);
            ClientResourceManager resourceManager = new ClientResourceManager(configuration, (MutableURLClassLoader)userClassLoader);
            return new EmbeddedSessionContext(defaultContext, sessionId, environment.getSessionEndpointVersion(), configuration, (URLClassLoader)((Object)userClassLoader), EmbeddedSessionContext.initializeSessionState((SessionEnvironment)environment, (Configuration)configuration, (ResourceManager)resourceManager), new OperationManager(operationExecutorService));
        }

        public OperationExecutor createOperationExecutor(Configuration executionConfig) {
            return new EmbeddedOperationExecutor(this, executionConfig);
        }
    }
}

