/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteRetry {
    protected static final Log LOG = LogFactory.getLog(RemoteRetry.class);
    protected static final Class<RuntimeException> RUNTIME_CLASS = RuntimeException.class;
    public static final RemoteRetry NEVER = new Never();
    public static final RemoteRetry SIMPLE = new Simple();
    public static final Always SIMPLE_ALWAYS = new SimpleAlways();

    protected RemoteRetry() {
    }

    protected static void simpleBackOff(int numRetries, Log log) {
        block4: {
            if (numRetries == 0) {
                return;
            }
            long sleepTime = numRetries;
            if (sleepTime > 30L) {
                sleepTime = 30L;
            }
            try {
                Thread.sleep(sleepTime * 1000L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Caught exception while sleeping", (Throwable)ignored);
            }
        }
    }

    protected final <RetType> RetType callImpl(Caller<RetType> caller, Log log) throws Throwable {
        int numTries = 0;
        while (true) {
            try {
                return caller.call();
            }
            catch (Throwable e) {
                if (!this.shouldRetry(e, ++numTries)) {
                    log.warn((Object)("Retry for caller " + caller + " giving up!"));
                    throw e;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Caller " + caller + " got exception, retrying"), e);
                }
                this.backOff(numTries, log);
                continue;
            }
            break;
        }
    }

    public <RetType> RetType call(Caller<RetType> caller) {
        return this.call(caller, LOG, RUNTIME_CLASS, RUNTIME_CLASS, RUNTIME_CLASS);
    }

    public <RetType> RetType call(Caller<RetType> caller, Log log) {
        return this.call(caller, log, RUNTIME_CLASS, RUNTIME_CLASS, RUNTIME_CLASS);
    }

    public <RetType, ExType1 extends Throwable> RetType call(Caller<RetType> caller, Class<ExType1> throwType1) throws ExType1 {
        return this.call(caller, LOG, throwType1, RUNTIME_CLASS, RUNTIME_CLASS);
    }

    public <RetType, ExType1 extends Throwable> RetType call(Caller<RetType> caller, Log log, Class<ExType1> throwType1) throws ExType1 {
        return this.call(caller, log, throwType1, RUNTIME_CLASS, RUNTIME_CLASS);
    }

    public <RetType, ExType1 extends Throwable, ExType2 extends Throwable> RetType call(Caller<RetType> caller, Class<ExType1> throwType1, Class<ExType2> throwType2) throws ExType1, ExType2 {
        return this.call(caller, LOG, throwType1, throwType2, RUNTIME_CLASS);
    }

    public <RetType, ExType1 extends Throwable, ExType2 extends Throwable> RetType call(Caller<RetType> caller, Log log, Class<ExType1> throwType1, Class<ExType2> throwType2) throws ExType1, ExType2 {
        return this.call(caller, log, throwType1, throwType2, RUNTIME_CLASS);
    }

    public <RetType, ExType1 extends Throwable, ExType2 extends Throwable, ExType3 extends Throwable> RetType call(Caller<RetType> caller, Class<ExType1> throwType1, Class<ExType2> throwType2, Class<ExType3> throwType3) throws ExType1, ExType2, ExType3 {
        return this.call(caller, LOG, throwType1, throwType2, throwType3);
    }

    public <RetType, ExType1 extends Throwable, ExType2 extends Throwable, ExType3 extends Throwable> RetType call(Caller<RetType> caller, Log log, Class<ExType1> throwType1, Class<ExType2> throwType2, Class<ExType3> throwType3) throws ExType1, ExType2, ExType3 {
        try {
            return this.callImpl(caller, log);
        }
        catch (Throwable e) {
            RemoteRetry.throwCommonTypes(e);
            RemoteRetry.throwIfMatchesType(e, throwType1);
            RemoteRetry.throwIfMatchesType(e, throwType2);
            RemoteRetry.throwIfMatchesType(e, throwType3);
            throw RemoteRetry.handleNoMatches(e);
        }
    }

    private static <ExType extends Throwable> void throwIfMatchesType(Throwable throwable, Class<ExType> throwType) throws ExType {
        if (throwType.isInstance(throwable)) {
            throw (Throwable)throwType.cast(throwable);
        }
    }

    private static void throwCommonTypes(Throwable throwable) {
        RemoteRetry.throwIfMatchesType(throwable, RuntimeException.class);
        RemoteRetry.throwIfMatchesType(throwable, Error.class);
    }

    private static Error handleNoMatches(Throwable throwable) {
        return (InternalError)new InternalError("Impossible exception thrown").initCause(throwable);
    }

    public abstract boolean shouldRetry(Throwable var1, int var2);

    public abstract void backOff(int var1, Log var2);

    public static final class Never
    extends RemoteRetry {
        public boolean shouldRetry(Throwable t, int numRetries) {
            return false;
        }

        public void backOff(int numRetries, Log log) {
            throw new UnsupportedOperationException("Should never be called");
        }
    }

    public static class SimpleAlways
    extends Always {
        public void backOff(int numRetries, Log log) {
            SimpleAlways.simpleBackOff(numRetries, log);
        }
    }

    public static abstract class Always
    extends RemoteRetry {
        protected Always() {
        }

        public final boolean shouldRetry(Throwable t, int numRetries) {
            return t instanceof RemoteException;
        }
    }

    public static class Simple
    extends RemoteRetry {
        public static final int DEFAULT_NUM_MAX_RETRIES = 5;
        private int _maxNumRetries;

        public Simple() {
            this(5);
        }

        public Simple(int maxNumRetries) {
            this._maxNumRetries = maxNumRetries;
        }

        public int getMaxNumRetries() {
            return this._maxNumRetries;
        }

        public boolean shouldRetry(Throwable t, int numRetries) {
            if (t instanceof RemoteException) {
                return numRetries < this.getMaxNumRetries();
            }
            return false;
        }

        public void backOff(int numRetries, Log log) {
            Simple.simpleBackOff(numRetries, log);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class VoidCaller
    extends Caller<Object> {
        @Override
        public final Object call() throws Exception {
            this.voidCall();
            return null;
        }

        public abstract void voidCall() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Caller<RetType> {
        public abstract RetType call() throws Exception;
    }
}

