/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.ops;

import java.util.List;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.ServerProxy;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.cq.internal.ops.CloseCQOp;
import org.apache.geode.cache.query.cq.internal.ops.CreateCQOp;
import org.apache.geode.cache.query.cq.internal.ops.CreateCQWithIROp;
import org.apache.geode.cache.query.cq.internal.ops.GetDurableCQsOp;
import org.apache.geode.cache.query.cq.internal.ops.StopCQOp;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.jetbrains.annotations.NotNull;

public class ServerCQProxyImpl
extends ServerProxy {
    public ServerCQProxyImpl(InternalPool pool) {
        super(pool);
    }

    public ServerCQProxyImpl(ServerProxy sp) {
        this(sp.getPool());
    }

    public Object create(ClientCQ cq) {
        this.pool.getRITracker().addCq(cq, cq.isDurable());
        return CreateCQOp.execute(this.pool, cq.getName(), cq.getQueryString(), 1, cq.isDurable(), this.getDataPolicy(cq));
    }

    public void createOn(@NotNull String cqName, @NotNull Connection conn, @NotNull String queryStr, int cqState, boolean isDurable, @NotNull DataPolicy regionDataPolicy) {
        CreateCQOp.executeOn(this.pool, conn, cqName, queryStr, cqState, isDurable, regionDataPolicy);
    }

    public SelectResults<?> createWithIR(ClientCQ cq) {
        this.pool.getRITracker().addCq(cq, cq.isDurable());
        return CreateCQWithIROp.execute(this.pool, cq.getName(), cq.getQueryString(), 1, cq.isDurable(), this.getDataPolicy(cq));
    }

    private DataPolicy getDataPolicy(ClientCQ cq) {
        return cq.getCqBaseRegion() == null ? DataPolicy.EMPTY : cq.getCqBaseRegion().getAttributes().getDataPolicy();
    }

    public void stop(ClientCQ cq) {
        this.pool.getRITracker().removeCq(cq);
        StopCQOp.execute(this.pool, cq.getName());
    }

    public void close(ClientCQ cq) {
        this.pool.getRITracker().removeCq(cq);
        CloseCQOp.execute(this.pool, cq.getName());
    }

    public List<String> getAllDurableCqsFromServer() {
        return GetDurableCQsOp.execute(this.pool);
    }
}

