/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.CatalogReplicaMode;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.trace.TableSpanBuilder;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HRegionLocator
implements RegionLocator {
    private final TableName tableName;
    private final ConnectionImplementation connection;

    public HRegionLocator(TableName tableName, ConnectionImplementation connection) {
        this.connection = connection;
        this.tableName = tableName;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row, int replicaId, boolean reload) throws IOException {
        TableSpanBuilder supplier = new TableSpanBuilder(this.connection).setName("HRegionLocator.getRegionLocation").setTableName(this.tableName);
        return this.tracedLocationFuture(() -> this.connection.locateRegion(this.tableName, row, !reload, true, replicaId).getRegionLocation(replicaId), AsyncRegionLocator::getRegionNames, supplier);
    }

    @Override
    public List<HRegionLocation> getRegionLocations(byte[] row, boolean reload) throws IOException {
        TableSpanBuilder supplier = new TableSpanBuilder(this.connection).setName("HRegionLocator.getRegionLocations").setTableName(this.tableName);
        RegionLocations locs = this.tracedLocationFuture(() -> this.connection.locateRegion(this.tableName, row, !reload, true, 0), AsyncRegionLocator::getRegionNames, supplier);
        return Arrays.asList(locs.getRegionLocations());
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        TableSpanBuilder supplier = new TableSpanBuilder(this.connection).setName("HRegionLocator.getAllRegionLocations").setTableName(this.tableName);
        return this.tracedLocationFuture(() -> {
            ArrayList<HRegionLocation> regions = new ArrayList<HRegionLocation>();
            for (RegionLocations locations : this.listRegionLocations()) {
                for (HRegionLocation location : locations.getRegionLocations()) {
                    regions.add(location);
                }
                RegionLocations cleaned = locations.removeElementsWithNullLocation();
                if (cleaned == null) continue;
                this.connection.cacheLocation(this.tableName, cleaned);
            }
            return regions;
        }, HRegionLocator::getRegionNames, supplier);
    }

    private static List<String> getRegionNames(List<HRegionLocation> locations) {
        if (CollectionUtils.isEmpty(locations)) {
            return Collections.emptyList();
        }
        return locations.stream().filter(Objects::nonNull).map(AsyncRegionLocator::getRegionNames).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public void clearRegionLocationCache() {
        TableSpanBuilder supplier = new TableSpanBuilder(this.connection).setName("HRegionLocator.clearRegionLocationCache").setTableName(this.tableName);
        TraceUtil.trace(() -> this.connection.clearRegionCache(this.tableName), (Supplier)supplier);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    private List<RegionLocations> listRegionLocations() throws IOException {
        if (TableName.isMetaTableName((TableName)this.tableName)) {
            return Collections.singletonList(this.connection.locateRegion(this.tableName, HConstants.EMPTY_START_ROW, false, true));
        }
        final ArrayList<RegionLocations> regions = new ArrayList<RegionLocations>();
        MetaTableAccessor.TableVisitorBase visitor = new MetaTableAccessor.TableVisitorBase(this.tableName){

            @Override
            public boolean visitInternal(Result result) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                regions.add(locations);
                return true;
            }
        };
        CatalogReplicaMode metaReplicaMode = CatalogReplicaMode.fromString(this.connection.getConfiguration().get("hbase.locator.meta.replicas.mode", CatalogReplicaMode.NONE.toString()));
        MetaTableAccessor.scanMetaForTableRegions(this.connection, visitor, this.tableName, metaReplicaMode);
        return regions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, T extends Throwable> R tracedLocationFuture(TraceUtil.ThrowingCallable<R, T> action, Function<R, List<String>> getRegionNames, Supplier<Span> spanSupplier) throws T {
        Span span = spanSupplier.get();
        try (Scope ignored = span.makeCurrent();){
            Object result = action.call();
            List<String> regionNames = getRegionNames.apply(result);
            if (!CollectionUtils.isEmpty(regionNames)) {
                span.setAttribute(HBaseSemanticAttributes.REGION_NAMES_KEY, regionNames);
            }
            span.setStatus(StatusCode.OK);
            span.end();
            Object object = result;
            return (R)object;
        }
        catch (Throwable e) {
            TraceUtil.setError((Span)span, (Throwable)e);
            span.end();
            throw e;
        }
    }
}

