/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestParallelReadUtil;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestParallelUnixDomainRead
extends TestParallelReadUtil {
    private static TemporarySocketDirectory sockDir;

    @BeforeClass
    public static void setupCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        DFSInputStream.tcpReadsDisabledForTesting = true;
        sockDir = new TemporarySocketDirectory();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestParallelLocalRead.%d.sock").getAbsolutePath());
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
        conf.setBoolean("dfs.client.domain.socket.data.traffic", true);
        DomainSocket.disableBindPathValidation();
        TestParallelUnixDomainRead.setupCluster(1, conf);
    }

    @Before
    public void before() {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        sockDir.close();
        TestParallelReadUtil.teardownCluster();
    }
}

