/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffListByArrayList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;
import org.apache.hadoop.test.Whitebox;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTruncateQuotaUpdate {
    private static final int BLOCKSIZE = 1024;
    private static final short REPLICATION = 4;
    private long nextMockBlockId;
    private long nextMockGenstamp;
    private long nextMockINodeId;

    @Test
    public void testTruncateWithoutSnapshot() {
        INodeFile file = this.createMockFile(2560L, (short)4);
        QuotaCounts count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(1536L, null, count);
        Assert.assertEquals((long)-2048L, (long)count.getStorageSpace());
        count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(1024L, null, count);
        Assert.assertEquals((long)-6144L, (long)count.getStorageSpace());
        count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(0L, null, count);
        Assert.assertEquals((long)-10240L, (long)count.getStorageSpace());
    }

    @Test
    public void testTruncateWithSnapshotNoDivergence() {
        INodeFile file = this.createMockFile(2560L, (short)4);
        TestTruncateQuotaUpdate.addSnapshotFeature(file, file.getBlocks());
        QuotaCounts count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(1536L, null, count);
        Assert.assertEquals((long)4096L, (long)count.getStorageSpace());
        count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(1024L, null, count);
        Assert.assertEquals((long)0L, (long)count.getStorageSpace());
        count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(0L, null, count);
        Assert.assertEquals((long)0L, (long)count.getStorageSpace());
    }

    @Test
    public void testTruncateWithSnapshotAndDivergence() {
        INodeFile file = this.createMockFile(2560L, (short)4);
        BlockInfo[] blocks = new BlockInfo[file.getBlocks().length];
        System.arraycopy(file.getBlocks(), 0, blocks, 0, blocks.length);
        TestTruncateQuotaUpdate.addSnapshotFeature(file, blocks);
        file.getBlocks()[1] = this.newBlock(1024L, (short)4);
        file.getBlocks()[2] = this.newBlock(512L, (short)4);
        QuotaCounts count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(1536L, null, count);
        Assert.assertEquals((long)-2048L, (long)count.getStorageSpace());
        count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(1536L, null, count);
        Assert.assertEquals((long)-2048L, (long)count.getStorageSpace());
        count = new QuotaCounts.Builder().build();
        file.computeQuotaDeltaForTruncate(0L, null, count);
        Assert.assertEquals((long)-6144L, (long)count.getStorageSpace());
    }

    private INodeFile createMockFile(long size, short replication) {
        ArrayList<BlockInfo> blocks = new ArrayList<BlockInfo>();
        for (long createdSize = 0L; createdSize < size; createdSize += 1024L) {
            long blockSize = Math.min(1024L, size - createdSize);
            BlockInfo bi = this.newBlock(blockSize, replication);
            blocks.add(bi);
        }
        PermissionStatus perm = new PermissionStatus("foo", "bar", FsPermission.createImmutable((short)511));
        return new INodeFile(++this.nextMockINodeId, new byte[0], perm, 0L, 0L, blocks.toArray(new BlockInfo[blocks.size()]), replication, 1024L);
    }

    private BlockInfo newBlock(long size, short replication) {
        Block b = new Block(++this.nextMockBlockId, size, ++this.nextMockGenstamp);
        return new BlockInfoContiguous(b, replication);
    }

    private static void addSnapshotFeature(INodeFile file, BlockInfo[] blocks) {
        FileDiff diff = (FileDiff)Mockito.mock(FileDiff.class);
        Mockito.when((Object)diff.getBlocks()).thenReturn((Object)blocks);
        FileDiffList diffList = new FileDiffList();
        Whitebox.setInternalState((Object)diffList, (String)"diffs", (Object)new DiffListByArrayList(0));
        DiffList diffs = (DiffList)Whitebox.getInternalState((Object)diffList, (String)"diffs");
        diffs.addFirst((Comparable)diff);
        FileWithSnapshotFeature sf = new FileWithSnapshotFeature(diffList);
        file.addFeature((INode.Feature)sf);
    }
}

