/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPGPolicyFacade {
    private static final Logger LOG = LoggerFactory.getLogger(GPGPolicyFacade.class);
    private FederationStateStoreFacade stateStore;
    private Map<String, FederationPolicyManager> policyManagerMap;
    private Map<String, SubClusterPolicyConfiguration> policyConfMap;
    private boolean readOnly;

    public GPGPolicyFacade(FederationStateStoreFacade stateStore, Configuration conf) {
        this.stateStore = stateStore;
        this.policyManagerMap = new HashMap<String, FederationPolicyManager>();
        this.policyConfMap = new HashMap<String, SubClusterPolicyConfiguration>();
        this.readOnly = conf.getBoolean("yarn.federation.gpg.policy.generator.readonly", false);
    }

    public FederationPolicyManager getPolicyManager(String queueName) throws YarnException {
        FederationPolicyManager policyManager = this.policyManagerMap.get(queueName);
        if (policyManager == null) {
            try {
                SubClusterPolicyConfiguration conf = this.policyConfMap.get(queueName);
                if (conf == null) {
                    conf = this.stateStore.getPolicyConfiguration(queueName);
                }
                if (conf == null) {
                    LOG.info("Read null policy for queue {}.", (Object)queueName);
                    return null;
                }
                String policyManagerType = conf.getType();
                policyManager = FederationPolicyUtils.instantiatePolicyManager((String)policyManagerType);
                policyManager.setQueue(queueName);
                if (policyManager.isSupportWeightedPolicyInfo()) {
                    ByteBuffer weightedPolicyInfoParams = conf.getParams();
                    if (weightedPolicyInfoParams == null) {
                        LOG.warn("Warning: Queue = {}, FederationPolicyManager {} WeightedPolicyInfo is empty.", (Object)queueName, (Object)policyManagerType);
                        return null;
                    }
                    WeightedPolicyInfo weightedPolicyInfo = WeightedPolicyInfo.fromByteBuffer((ByteBuffer)conf.getParams());
                    policyManager.setWeightedPolicyInfo(weightedPolicyInfo);
                } else {
                    LOG.warn("Warning: FederationPolicyManager of unsupported WeightedPolicyInfo type {}, initialization may be incomplete.", policyManager.getClass());
                }
                this.policyManagerMap.put(queueName, policyManager);
                this.policyConfMap.put(queueName, conf);
            }
            catch (YarnException e) {
                LOG.error("Error reading SubClusterPolicyConfiguration from state store for queue: {}", (Object)queueName);
                throw e;
            }
        }
        return policyManager;
    }

    public void setPolicyManager(FederationPolicyManager policyManager) throws YarnException {
        SubClusterPolicyConfiguration conf;
        if (policyManager == null) {
            LOG.warn("Attempting to set null policy manager");
            return;
        }
        String queue = policyManager.getQueue();
        try {
            conf = policyManager.serializeConf();
        }
        catch (FederationPolicyInitializationException e) {
            LOG.warn("Error serializing policy for queue {}", (Object)queue);
            throw e;
        }
        if (conf == null) {
            LOG.warn("Skip setting policy to null for queue {} into state store", (Object)queue);
            return;
        }
        if (!this.confCacheEqual(queue, conf)) {
            try {
                if (this.readOnly) {
                    LOG.info("[read-only] Skipping policy update for queue {}", (Object)queue);
                    return;
                }
                LOG.info("Updating policy for queue {} into state store", (Object)queue);
                this.stateStore.setPolicyConfiguration(conf);
                this.policyConfMap.put(queue, conf);
                this.policyManagerMap.put(queue, policyManager);
            }
            catch (YarnException e) {
                LOG.warn("Error writing SubClusterPolicyConfiguration to state store for queue: {}", (Object)queue);
                throw e;
            }
        } else {
            LOG.info("Setting unchanged policy - state store write skipped");
        }
    }

    private boolean confCacheEqual(String queue, SubClusterPolicyConfiguration conf) {
        SubClusterPolicyConfiguration cachedConf = this.policyConfMap.get(queue);
        if (conf == null && cachedConf == null) {
            return true;
        }
        return conf != null && cachedConf != null && conf.equals((Object)cachedConf);
    }
}

