/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.applicationcleaner;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.utils.FederationRegistryClient;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGContext;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.DeSelectFields;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationCleaner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationCleaner.class);
    private Configuration conf;
    private GPGContext gpgContext;
    private FederationRegistryClient registryClient;
    private int minRouterSuccessCount;
    private int maxRouterRetry;
    private long routerQueryIntevalMillis;

    public void init(Configuration config, GPGContext context) throws YarnException {
        this.gpgContext = context;
        this.conf = config;
        this.registryClient = context.getRegistryClient();
        String routerSpecString = this.conf.get("yarn.federation.gpg.application.cleaner.contact.router.spec", "3,10,600000");
        String[] specs = routerSpecString.split(",");
        if (specs.length != 3) {
            throw new YarnException("Expect three comma separated values in yarn.federation.gpg.application.cleaner.contact.router.spec but get " + routerSpecString);
        }
        this.minRouterSuccessCount = Integer.parseInt(specs[0]);
        this.maxRouterRetry = Integer.parseInt(specs[1]);
        this.routerQueryIntevalMillis = Long.parseLong(specs[2]);
        if (this.minRouterSuccessCount > this.maxRouterRetry) {
            throw new YarnException("minRouterSuccessCount " + this.minRouterSuccessCount + " should not be larger than maxRouterRetry" + this.maxRouterRetry);
        }
        if (this.minRouterSuccessCount <= 0) {
            throw new YarnException("minRouterSuccessCount " + this.minRouterSuccessCount + " should be positive");
        }
        LOG.info("Initialized AppCleaner with Router query with min success {}, max retry {}, retry interval {}.", new Object[]{this.minRouterSuccessCount, this.maxRouterRetry, DurationFormatUtils.formatDurationISO((long)this.routerQueryIntevalMillis)});
    }

    public GPGContext getGPGContext() {
        return this.gpgContext;
    }

    public FederationRegistryClient getRegistryClient() {
        return this.registryClient;
    }

    public Set<ApplicationId> getAppsFromRouter() throws YarnRuntimeException {
        String webAppAddress = WebAppUtils.getRouterWebAppURLWithScheme((Configuration)this.conf);
        LOG.info("Contacting router at: {}.", (Object)webAppAddress);
        AppsInfo appsInfo = GPGUtils.invokeRMWebService(webAppAddress, "/apps", AppsInfo.class, this.conf, DeSelectFields.DeSelectType.RESOURCE_REQUESTS.toString());
        HashSet<ApplicationId> appSet = new HashSet<ApplicationId>();
        for (AppInfo appInfo : appsInfo.getApps()) {
            appSet.add(ApplicationId.fromString((String)appInfo.getAppId()));
        }
        return appSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ApplicationId> getRouterKnownApplications() throws YarnException {
        int successCount = 0;
        int totalAttemptCount = 0;
        HashSet<ApplicationId> resultSet = new HashSet<ApplicationId>();
        while (totalAttemptCount < this.maxRouterRetry) {
            try {
                Set<ApplicationId> routerApps = this.getAppsFromRouter();
                resultSet.addAll(routerApps);
                LOG.info("Attempt {}: {} known apps from Router, {} in total", new Object[]{totalAttemptCount, routerApps.size(), resultSet.size()});
                if (++successCount >= this.minRouterSuccessCount) {
                    HashSet<ApplicationId> hashSet = resultSet;
                    return hashSet;
                }
                try {
                    Thread.sleep(this.routerQueryIntevalMillis);
                }
                catch (InterruptedException e) {
                    LOG.warn("Sleep interrupted after attempt {}.", (Object)totalAttemptCount);
                }
            }
            catch (Exception e) {
                LOG.warn("Router query attempt {} failed.", (Object)totalAttemptCount, (Object)e);
            }
            finally {
                ++totalAttemptCount;
            }
        }
        throw new YarnException("Only " + successCount + " success Router queries after " + totalAttemptCount + " retries");
    }

    @Override
    public abstract void run();
}

