/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;

@InterfaceAudience.Private
public class ActiveState
extends HAState {
    public ActiveState() {
        super(HAServiceProtocol.HAServiceState.ACTIVE);
    }

    @Override
    public void checkOperation(HAContext context, NameNode.OperationCategory op) {
    }

    @Override
    public boolean shouldPopulateReplQueues() {
        return true;
    }

    @Override
    public void setState(HAContext context, HAState s) throws ServiceFailedException {
        if (s == NameNode.STANDBY_STATE) {
            this.setStateInternal(context, s);
            return;
        }
        super.setState(context, s);
    }

    @Override
    public void enterState(HAContext context) throws ServiceFailedException {
        try {
            context.startActiveServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to start active services", (Throwable)e);
        }
    }

    @Override
    public void exitState(HAContext context) throws ServiceFailedException {
        try {
            context.stopActiveServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to stop active services", (Throwable)e);
        }
    }
}

