/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.AllocationExpirationInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;

public class ContainerAllocationExpirer
extends AbstractLivelinessMonitor<AllocationExpirationInfo> {
    private EventHandler dispatcher;

    public ContainerAllocationExpirer(Dispatcher d) {
        super(ContainerAllocationExpirer.class.getName());
        this.dispatcher = d.getEventHandler();
    }

    public void serviceInit(Configuration conf) throws Exception {
        int expireIntvl = conf.getInt("yarn.resourcemanager.rm.container-allocation.expiry-interval-ms", 600000);
        this.setExpireInterval(expireIntvl);
        this.setMonitorInterval(expireIntvl / 3);
        super.serviceInit(conf);
    }

    protected void expire(AllocationExpirationInfo allocationExpirationInfo) {
        this.dispatcher.handle((Event)new ContainerExpiredSchedulerEvent(allocationExpirationInfo.getContainerId(), allocationExpirationInfo.isIncrease()));
    }
}

