/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.Map;

public class UnauthorizedException
extends DocumentClientException {
    public UnauthorizedException() {
        this("Unable to authenticate the request. The request requires valid user authentication.");
    }

    public UnauthorizedException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(401, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public UnauthorizedException(String message) {
        this(message, null, (HttpResponseHeaders)null, null);
    }

    public UnauthorizedException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public UnauthorizedException(String message, HttpResponseHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    public UnauthorizedException(Exception innerException) {
        this("Unable to authenticate the request. The request requires valid user authentication.", innerException, null, null);
    }

    public UnauthorizedException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("%s: %s", "Unable to authenticate the request. The request requires valid user authentication.", message), innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 401, requestUri != null ? requestUri.toString() : null);
    }
}

