/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.function.multiary.AbstractMultiary;
import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.QuadraticFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public final class CompoundFunction<N extends Number>
extends AbstractMultiary<N, CompoundFunction<N>>
implements MultiaryFunction.Linear<N>,
MultiaryFunction.Quadratic<N> {
    private final LinearFunction<N> myLinear;
    private final QuadraticFunction<N> myQuadratic;

    public static CompoundFunction<BigDecimal> makeBig(Access2D<? extends Number> quadraticFactors, Access1D<? extends Number> linearFactors) {
        QuadraticFunction<BigDecimal> tmpQuadratic = QuadraticFunction.makeBig(quadraticFactors);
        LinearFunction<BigDecimal> tmpLinear = LinearFunction.makeBig(linearFactors);
        return new CompoundFunction<BigDecimal>(tmpQuadratic, tmpLinear);
    }

    public static CompoundFunction<BigDecimal> makeBig(int arity) {
        QuadraticFunction<BigDecimal> tmpQuadratic = QuadraticFunction.makeBig(arity);
        LinearFunction<BigDecimal> tmpLinear = LinearFunction.makeBig(arity);
        return new CompoundFunction<BigDecimal>(tmpQuadratic, tmpLinear);
    }

    public static CompoundFunction<ComplexNumber> makeComplex(Access2D<? extends Number> quadraticFactors, Access1D<? extends Number> linearFactors) {
        QuadraticFunction<ComplexNumber> tmpQuadratic = QuadraticFunction.makeComplex(quadraticFactors);
        LinearFunction<ComplexNumber> tmpLinear = LinearFunction.makeComplex(linearFactors);
        return new CompoundFunction<ComplexNumber>(tmpQuadratic, tmpLinear);
    }

    public static CompoundFunction<ComplexNumber> makeComplex(int arity) {
        QuadraticFunction<ComplexNumber> tmpQuadratic = QuadraticFunction.makeComplex(arity);
        LinearFunction<ComplexNumber> tmpLinear = LinearFunction.makeComplex(arity);
        return new CompoundFunction<ComplexNumber>(tmpQuadratic, tmpLinear);
    }

    public static CompoundFunction<Double> makePrimitive(Access2D<? extends Number> quadraticFactors, Access1D<? extends Number> linearFactors) {
        QuadraticFunction<Double> tmpQuadratic = QuadraticFunction.makePrimitive(quadraticFactors);
        LinearFunction<Double> tmpLinear = LinearFunction.makePrimitive(linearFactors);
        return new CompoundFunction<Double>(tmpQuadratic, tmpLinear);
    }

    public static CompoundFunction<Double> makePrimitive(int arity) {
        QuadraticFunction<Double> tmpQuadratic = QuadraticFunction.makePrimitive(arity);
        LinearFunction<Double> tmpLinear = LinearFunction.makePrimitive(arity);
        return new CompoundFunction<Double>(tmpQuadratic, tmpLinear);
    }

    CompoundFunction(QuadraticFunction<N> quadratic, LinearFunction<N> linear) {
        this.myQuadratic = quadratic;
        this.myLinear = linear;
        if (this.myQuadratic.arity() != this.myLinear.arity()) {
            throw new IllegalArgumentException("Must have the same dim()!");
        }
    }

    @Override
    public int arity() {
        return this.myLinear.arity();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.myQuadratic.getGradient(point).logical().superimpose(0, 0, this.myLinear.getGradient(point)).get();
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myQuadratic.getHessian(point);
    }

    @Override
    public N invoke(Access1D<N> arg) {
        Scalar retVal = this.getScalarConstant();
        retVal = (Scalar)retVal.add(this.myLinear.invoke(arg));
        retVal = (Scalar)retVal.add(this.myQuadratic.invoke(arg));
        return retVal.getNumber();
    }

    @Override
    public PhysicalStore<N> linear() {
        return this.myLinear.linear();
    }

    @Override
    public PhysicalStore<N> quadratic() {
        return this.myQuadratic.quadratic();
    }

    @Override
    protected PhysicalStore.Factory<N, ?> factory() {
        return this.myLinear.factory();
    }
}

