/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Optimisation;

public abstract class GenericSolver
implements Optimisation.Solver,
Serializable {
    public final Optimisation.Options options;
    private final AtomicInteger myIterationsCount = new AtomicInteger(0);
    private long myResetTime;
    private Optimisation.State myState = Optimisation.State.UNEXPLORED;

    private GenericSolver() {
        this(null);
    }

    protected GenericSolver(Optimisation.Options solverOptions) {
        this.options = solverOptions != null ? solverOptions : new Optimisation.Options();
    }

    protected Optimisation.Result buildResult() {
        MatrixStore<Double> tmpSolution = this.extractSolution();
        double tmpValue = this.evaluateFunction(tmpSolution);
        Optimisation.State tmpState = this.getState();
        return new Optimisation.Result(tmpState, tmpValue, tmpSolution);
    }

    protected final int countIterations() {
        return this.myIterationsCount.get();
    }

    protected final long countTime() {
        return System.currentTimeMillis() - this.myResetTime;
    }

    protected final void debug(String descripttion, Access2D<?> matrix) {
        if (this.options.debug_appender != null) {
            this.options.debug_appender.printmtrx(descripttion, matrix, this.options.print);
        }
    }

    protected final void debug(String messagePattern, Object ... arguments) {
        if (this.options.debug_appender != null) {
            this.options.debug_appender.println(messagePattern, arguments);
        }
    }

    protected final void error(String messagePattern, Object ... arguments) {
        BasicLogger.error(messagePattern, arguments);
    }

    protected abstract double evaluateFunction(Access1D<?> var1);

    protected abstract MatrixStore<Double> extractSolution();

    protected final Optimisation.State getState() {
        return this.myState;
    }

    protected final int incrementIterationsCount() {
        return this.myIterationsCount.incrementAndGet();
    }

    protected abstract boolean initialise(Optimisation.Result var1);

    protected final boolean isDebug() {
        return this.options.debug_appender != null && this.options.debug_solver.isAssignableFrom(this.getClass());
    }

    protected final boolean isIterationAllowed() {
        int tmpIterations = this.countIterations();
        long tmpTime = this.countTime();
        boolean tmpIterationOk = tmpIterations < this.options.iterations_abort;
        boolean tmpTimeOk = tmpTime < this.options.time_abort;
        return tmpTimeOk && tmpIterationOk;
    }

    protected abstract boolean needsAnotherIteration();

    protected final void resetIterationsCount() {
        this.myIterationsCount.set(0);
        this.myResetTime = System.currentTimeMillis();
    }

    protected final void setState(Optimisation.State aState) {
        this.myState = aState;
    }

    protected abstract boolean validate();
}

