/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.math.MathContext;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.iterative.ConjugateGradientSolver;
import org.ojalgo.matrix.task.iterative.Equation;
import org.ojalgo.matrix.task.iterative.MutableSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ActiveSetSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.type.context.NumberContext;

abstract class IterativeASS
extends ActiveSetSolver {
    private final MyIterativeSolver myS = new MyIterativeSolver();

    IterativeASS(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    @Override
    protected void performIteration() {
        if (this.isDebug()) {
            this.debug("\nPerformIteration {}", 1 + this.countIterations());
            this.debug(this.myActivator.toString(), new Object[0]);
        }
        int tmpToInclude = this.myConstraintToInclude;
        this.myConstraintToInclude = -1;
        int[] tmpIncluded = this.myActivator.getIncluded();
        MatrixStore<Double> tmpIterC = this.getIterationC();
        MatrixStore<Double> tmpIterA = this.getIterationA(tmpIncluded);
        long tmpCountRowsIterA = tmpIterA.countRows();
        long tmpCountColsIterA = tmpIterA.countColumns();
        boolean tmpSolvable = false;
        int tmpCountE = this.countEqualityConstraints();
        if (tmpToInclude >= 0) {
            MatrixStore<Double> tmpElements = this.myCholesky.getSolution(this.getAI().logical().row(tmpToInclude).transpose());
            double tmpRHS = this.myInvQC.premultiply(this.getAI().sliceRow(tmpToInclude, 0L)).get().doubleValue(0L) - this.getBI().doubleValue(tmpToInclude);
            this.myS.add(tmpCountE + tmpToInclude, tmpElements, tmpRHS, 3);
        }
        if (tmpCountRowsIterA < tmpCountColsIterA && (tmpSolvable = this.myCholesky.isSolvable())) {
            if (tmpCountRowsIterA == 0L) {
                this.myCholesky.getSolution(tmpIterC, this.myIterationX);
            } else {
                double tmpRelativeError = this.myS.resolve(this.myIterationL);
                if (this.isDebug()) {
                    this.debug("Relative error in solution for L={}", tmpRelativeError);
                }
                this.myCholesky.getSolution(this.getIterationL(tmpIncluded).premultiply((Access1D<Double>)((Object)tmpIterA.transpose())).operateOnMatching(tmpIterC, (BinaryFunction<Double>)PrimitiveFunction.SUBTRACT), this.myIterationX);
            }
        }
        if (!tmpSolvable && (tmpSolvable = this.myLU.compute(this.getIterationKKT(tmpIncluded)))) {
            MatrixStore tmpXL = this.myLU.getSolution(this.getIterationRHS(tmpIncluded));
            int tmpCountVariables = this.countVariables();
            this.myIterationX.fillMatching((MatrixStore<Double>)tmpXL.logical().limits(tmpCountVariables, (int)tmpXL.countColumns()).get());
            for (int i = 0; i < tmpCountE; ++i) {
                this.myIterationL.set((long)i, tmpXL.doubleValue(tmpCountVariables + i));
            }
            int tmpLengthIncluded = tmpIncluded.length;
            for (int i = 0; i < tmpLengthIncluded; ++i) {
                this.myIterationL.set((long)(tmpCountE + tmpIncluded[i]), tmpXL.doubleValue(tmpCountVariables + tmpCountE + i));
            }
        }
        if (!tmpSolvable && this.isDebug()) {
            this.options.debug_appender.println("KKT system unsolvable!");
            if ((long)this.countVariables() + tmpCountColsIterA < 20L) {
                this.options.debug_appender.printmtrx("KKT", this.getIterationKKT());
                this.options.debug_appender.printmtrx("RHS", this.getIterationRHS());
            }
        }
        this.handleSubsolution(tmpSolvable, this.myIterationX, tmpIncluded);
    }

    @Override
    void excludeAndRemove(int toExclude) {
        this.myActivator.exclude(toExclude);
        this.myS.remove(this.countEqualityConstraints() + toExclude);
    }

    @Override
    void initSolution(MatrixStore<Double> tmpBI, int tmpNumVars, int tmpNumEqus) {
        if (this.hasInequalityConstraints()) {
            int[] tmpExcluded = this.myActivator.getExcluded();
            MatrixStore<Double> tmpAIX = this.getAIX(tmpExcluded);
            for (int i = 0; i < tmpExcluded.length; ++i) {
                double tmpBody = tmpAIX.doubleValue(i);
                double tmpRHS = tmpBI.doubleValue(tmpExcluded[i]);
                if (this.options.slack.isDifferent(tmpRHS, tmpBody) || this.myIterationL.doubleValue((long)(tmpNumEqus + tmpExcluded[i])) == PrimitiveMath.ZERO) continue;
                this.myActivator.include(tmpExcluded[i]);
            }
        }
        while (tmpNumEqus + this.myActivator.countIncluded() >= tmpNumVars && this.myActivator.countIncluded() > 0) {
            this.shrink();
        }
        if (this.isDebug() && tmpNumEqus + this.myActivator.countIncluded() > tmpNumVars) {
            this.debug("Redundant contraints!", new Object[0]);
        }
        this.myInvQC = this.myCholesky.getSolution(this.getIterationC());
        int[] tmpIncluded = this.myActivator.getIncluded();
        this.myS.clear();
        if (tmpNumEqus + tmpIncluded.length > 0) {
            int j;
            MatrixStore<Double> tmpIterA = this.getIterationA(tmpIncluded);
            MatrixStore<Double> tmpIterB = this.getIterationB(tmpIncluded);
            MatrixStore tmpCols = this.myCholesky.getSolution(tmpIterA.transpose());
            Object tmpRHS = this.myInvQC.premultiply(tmpIterA).operateOnMatching((BinaryFunction<Double>)PrimitiveFunction.SUBTRACT, tmpIterB).get();
            for (j = 0; j < tmpNumEqus; ++j) {
                this.myS.add(j, tmpCols.sliceColumn(0L, j), tmpRHS.doubleValue(j), tmpNumVars);
            }
            for (j = 0; j < tmpIncluded.length; ++j) {
                this.myS.add(tmpNumEqus + tmpIncluded[j], tmpCols.sliceColumn(0L, tmpNumEqus + j), tmpRHS.doubleValue(tmpNumEqus + j), 3);
            }
        }
    }

    final class MyIterativeSolver
    extends MutableSolver<ConjugateGradientSolver>
    implements Access2D<Double> {
        private final int myCountE;
        private final long myFullDim;
        private final Equation[] myIterationRows;

        MyIterativeSolver() {
            super(new ConjugateGradientSolver(), IterativeASS.this.countEqualityConstraints() + IterativeASS.this.countInequalityConstraints());
            this.myCountE = IterativeASS.this.countEqualityConstraints();
            this.myFullDim = this.myCountE + IterativeASS.this.countInequalityConstraints();
            this.setAccuracyContext(NumberContext.getMath(MathContext.DECIMAL64).newPrecision(9));
            this.myIterationRows = new Equation[(int)this.myFullDim];
        }

        @Override
        public long countColumns() {
            return IterativeASS.this.countEqualityConstraints() + IterativeASS.this.myActivator.countIncluded();
        }

        @Override
        public long countRows() {
            return IterativeASS.this.countEqualityConstraints() + IterativeASS.this.myActivator.countIncluded();
        }

        @Override
        public double doubleValue(long row, long col) {
            int tmpColumn = (int)col;
            if (tmpColumn >= this.myCountE) {
                tmpColumn = this.myCountE + IterativeASS.this.myActivator.getIncluded()[tmpColumn - this.myCountE];
            }
            return this.doubleValue((int)row, tmpColumn);
        }

        @Override
        public Double get(long row, long col) {
            return this.doubleValue(row, col);
        }

        void add(int j, Access1D<Double> column, double rhs, int numberOfNonzeros) {
            double tmpVal;
            Equation tmpNewRow;
            int[] myIncluded = IterativeASS.this.myActivator.getIncluded();
            this.myIterationRows[j] = tmpNewRow = new Equation(j, this.myFullDim, rhs, numberOfNonzeros);
            this.add(tmpNewRow);
            if (IterativeASS.this.getAE() != null) {
                PhysicalStore tmpProdE = (PhysicalStore)IterativeASS.this.getAE().physical().makeZero(IterativeASS.this.getAE().countRows(), 1L);
                IterativeASS.this.getAE().multiply(column, tmpProdE);
                for (int i = 0; i < this.myCountE; ++i) {
                    tmpVal = tmpProdE.doubleValue(i);
                    if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                    Equation tmpRowE = this.myIterationRows[i];
                    if (tmpRowE != null) {
                        tmpRowE.set((long)j, tmpVal);
                    }
                    tmpNewRow.set((long)i, tmpVal);
                }
            }
            if (IterativeASS.this.getAI() != null && myIncluded.length > 0) {
                PhysicalStore tmpProdI = (PhysicalStore)IterativeASS.this.getAI().physical().makeZero(myIncluded.length, 1L);
                IterativeASS.this.getAI().logical().row(myIncluded).get().multiply(column, tmpProdI);
                for (int _i = 0; _i < myIncluded.length; ++_i) {
                    tmpVal = tmpProdI.doubleValue(_i);
                    if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                    int i = this.myCountE + myIncluded[_i];
                    Equation tmpRowI = this.myIterationRows[i];
                    if (tmpRowI != null) {
                        tmpRowI.set((long)j, tmpVal);
                    }
                    tmpNewRow.set((long)i, tmpVal);
                }
            }
            tmpNewRow.initialise(IterativeASS.this.myIterationL);
        }

        void remove(int i) {
            Equation tmpO = this.myIterationRows[i];
            if (tmpO != null) {
                this.remove(tmpO);
            }
            this.myIterationRows[i] = null;
            IterativeASS.this.myIterationL.set((long)i, PrimitiveMath.ZERO);
        }
    }
}

